/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.support.filter;

import org.springframework.ldap.support.LdapEncoder;
import org.springframework.ldap.support.filter.EqualsFilter;

public class LikeFilter
extends EqualsFilter {
    public LikeFilter(String attribute, String value) {
        super(attribute, value);
    }

    protected String encodeValue(String value) {
        if (value == null) {
            return "";
        }
        String[] substrings = value.split("\\*", -2);
        if (substrings.length == 1) {
            return LdapEncoder.filterEncode(substrings[0]);
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < substrings.length; ++i) {
            buff.append(LdapEncoder.filterEncode(substrings[i]));
            if (i < substrings.length - 1) {
                buff.append("*");
                continue;
            }
            if (!substrings[i].equals("")) continue;
        }
        return buff.toString();
    }
}

