/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.method.HandlerTypePredicate;

public class ControllerAdviceBean
implements Ordered {
    private final String beanName;
    private final boolean isSingleton;
    private @Nullable Object resolvedBean;
    private final @Nullable Class<?> beanType;
    private final HandlerTypePredicate beanTypePredicate;
    private final BeanFactory beanFactory;
    private @Nullable Integer order;

    public ControllerAdviceBean(String beanName, BeanFactory beanFactory, ControllerAdvice controllerAdvice) {
        Assert.hasText((String)beanName, (String)"Bean name must contain text");
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        Assert.isTrue((boolean)beanFactory.containsBean(beanName), () -> "BeanFactory [" + String.valueOf(beanFactory) + "] does not contain specified controller advice bean '" + beanName + "'");
        Assert.notNull((Object)controllerAdvice, (String)"ControllerAdvice must not be null");
        this.beanName = beanName;
        this.isSingleton = beanFactory.isSingleton(beanName);
        this.beanType = ControllerAdviceBean.getBeanType(beanName, beanFactory);
        this.beanTypePredicate = ControllerAdviceBean.createBeanTypePredicate(controllerAdvice);
        this.beanFactory = beanFactory;
    }

    public int getOrder() {
        if (this.order == null) {
            Object resolvedBean = null;
            String targetBeanName = ScopedProxyUtils.getTargetBeanName((String)this.beanName);
            boolean isScopedProxy = this.beanFactory.containsBean(targetBeanName);
            if (!isScopedProxy && !ScopedProxyUtils.isScopedTarget((String)this.beanName)) {
                resolvedBean = this.resolveBean();
            }
            if (resolvedBean instanceof Ordered) {
                Ordered ordered = (Ordered)resolvedBean;
                this.order = ordered.getOrder();
            } else {
                BeanFactory beanFactory = this.beanFactory;
                if (beanFactory instanceof ConfigurableBeanFactory) {
                    ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
                    try {
                        RootBeanDefinition rbd;
                        Method factoryMethod;
                        BeanDefinition bd = cbf.getMergedBeanDefinition(this.beanName);
                        if (bd instanceof RootBeanDefinition && (factoryMethod = (rbd = (RootBeanDefinition)bd).getResolvedFactoryMethod()) != null) {
                            this.order = OrderUtils.getOrder((AnnotatedElement)factoryMethod);
                        }
                    }
                    catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                        // empty catch block
                    }
                }
                if (this.order == null) {
                    this.order = this.beanType != null ? Integer.valueOf(OrderUtils.getOrder(this.beanType, (int)Integer.MAX_VALUE)) : Integer.valueOf(Integer.MAX_VALUE);
                }
            }
        }
        return this.order;
    }

    public @Nullable Class<?> getBeanType() {
        return this.beanType;
    }

    public Object resolveBean() {
        if (this.resolvedBean == null) {
            Object resolvedBean = this.beanFactory.getBean(this.beanName);
            if (!this.isSingleton) {
                return resolvedBean;
            }
            this.resolvedBean = resolvedBean;
        }
        return this.resolvedBean;
    }

    public boolean isApplicableToBeanType(@Nullable Class<?> beanType) {
        return this.beanTypePredicate.test(beanType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ControllerAdviceBean)) return false;
        ControllerAdviceBean that = (ControllerAdviceBean)other;
        if (!this.beanName.equals(that.beanName)) return false;
        if (this.beanFactory != that.beanFactory) return false;
        return true;
    }

    public int hashCode() {
        return this.beanName.hashCode();
    }

    public String toString() {
        return this.beanName;
    }

    public static List<ControllerAdviceBean> findAnnotatedBeans(ApplicationContext context) {
        return ControllerAdviceBean.findAnnotatedBeans((ListableBeanFactory)context);
    }

    public static List<ControllerAdviceBean> findAnnotatedBeans(ListableBeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cac = (ConfigurableApplicationContext)beanFactory;
            beanFactory = cac.getBeanFactory();
        }
        ArrayList<ControllerAdviceBean> adviceBeans = new ArrayList<ControllerAdviceBean>();
        for (String name : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, Object.class)) {
            ControllerAdvice controllerAdvice;
            if (ScopedProxyUtils.isScopedTarget((String)name) || (controllerAdvice = (ControllerAdvice)beanFactory.findAnnotationOnBean(name, ControllerAdvice.class)) == null) continue;
            adviceBeans.add(new ControllerAdviceBean(name, (BeanFactory)beanFactory, controllerAdvice));
        }
        OrderComparator.sort(adviceBeans);
        return adviceBeans;
    }

    private static @Nullable Class<?> getBeanType(String beanName, BeanFactory beanFactory) {
        Class beanType = beanFactory.getType(beanName);
        return beanType != null ? ClassUtils.getUserClass((Class)beanType) : null;
    }

    private static HandlerTypePredicate createBeanTypePredicate(ControllerAdvice controllerAdvice) {
        return HandlerTypePredicate.builder().basePackage(controllerAdvice.basePackages()).basePackageClass(controllerAdvice.basePackageClasses()).assignableType(controllerAdvice.assignableTypes()).annotation(controllerAdvice.annotations()).build();
    }
}

