/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPatternParser;

public class PathMatchConfigurer {
    private boolean preferPathMatcher = false;
    private @Nullable PathPatternParser patternParser;
    private @Nullable Map<String, Predicate<Class<?>>> pathPrefixes;
    private @Nullable UrlPathHelper urlPathHelper;
    private @Nullable PathMatcher pathMatcher;
    private @Nullable PathPatternParser defaultPatternParser;
    private @Nullable UrlPathHelper defaultUrlPathHelper;
    private @Nullable PathMatcher defaultPathMatcher;

    public PathMatchConfigurer setPatternParser(@Nullable PathPatternParser patternParser) {
        this.patternParser = patternParser;
        this.preferPathMatcher = patternParser == null;
        return this;
    }

    public PathMatchConfigurer addPathPrefix(String prefix, Predicate<Class<?>> predicate) {
        if (this.pathPrefixes == null) {
            this.pathPrefixes = new LinkedHashMap();
        }
        this.pathPrefixes.put(prefix, predicate);
        return this;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public PathMatchConfigurer setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
        this.preferPathMatcher = true;
        return this;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public PathMatchConfigurer setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
        this.preferPathMatcher = true;
        return this;
    }

    @Deprecated(since="7.0", forRemoval=true)
    protected boolean preferPathMatcher() {
        return this.patternParser == null && this.preferPathMatcher;
    }

    public @Nullable PathPatternParser getPatternParser() {
        return this.patternParser;
    }

    protected @Nullable Map<String, Predicate<Class<?>>> getPathPrefixes() {
        return this.pathPrefixes;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public @Nullable UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public @Nullable PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Deprecated(since="7.0", forRemoval=true)
    protected UrlPathHelper getUrlPathHelperOrDefault() {
        if (this.urlPathHelper != null) {
            return this.urlPathHelper;
        }
        if (this.defaultUrlPathHelper == null) {
            this.defaultUrlPathHelper = new UrlPathHelper();
        }
        return this.defaultUrlPathHelper;
    }

    @Deprecated(since="7.0", forRemoval=true)
    protected PathMatcher getPathMatcherOrDefault() {
        if (this.pathMatcher != null) {
            return this.pathMatcher;
        }
        if (this.defaultPathMatcher == null) {
            this.defaultPathMatcher = new AntPathMatcher();
        }
        return this.defaultPathMatcher;
    }

    public PathPatternParser getPatternParserOrDefault() {
        if (this.patternParser != null) {
            return this.patternParser;
        }
        if (this.defaultPatternParser == null) {
            this.defaultPatternParser = new PathPatternParser();
        }
        return this.defaultPatternParser;
    }
}

