/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DeferredResultMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    public boolean supportsReturnType(MethodParameter returnType) {
        Class type = returnType.getParameterType();
        return DeferredResult.class.isAssignableFrom(type) || CompletionStage.class.isAssignableFrom(type);
    }

    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        DeferredResult<Object> result;
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        if (returnValue instanceof DeferredResult) {
            DeferredResult<Object> deferredResult;
            result = deferredResult = (DeferredResult<Object>)returnValue;
        } else if (returnValue instanceof CompletionStage) {
            CompletionStage completionStage = (CompletionStage)returnValue;
            result = this.adaptCompletionStage(completionStage);
        } else {
            throw new IllegalStateException("Unexpected return value type: " + String.valueOf(returnValue));
        }
        WebAsyncUtils.getAsyncManager((WebRequest)webRequest).startDeferredResultProcessing(result, new Object[]{mavContainer});
    }

    private DeferredResult<Object> adaptCompletionStage(CompletionStage<?> future) {
        DeferredResult result = new DeferredResult();
        future.whenComplete((value, ex) -> {
            if (ex != null) {
                if (ex instanceof CompletionException && ex.getCause() != null) {
                    ex = ex.getCause();
                }
                result.setErrorResult(ex);
            } else {
                result.setResult(value);
            }
        });
        return result;
    }
}

