/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractWebSocketClient
implements WebSocketClient {
    private static final Set<String> specialHeaders = Set.of("cache-control", "connection", "host", "sec-websocket-extensions", "sec-websocket-key", "sec-websocket-protocol", "sec-websocket-version", "pragma", "upgrade");
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public CompletableFuture<WebSocketSession> execute(WebSocketHandler webSocketHandler, String uriTemplate, Object ... uriVars) {
        Assert.notNull((Object)uriTemplate, (String)"'uriTemplate' must not be null");
        URI uri = UriComponentsBuilder.fromUriString((String)uriTemplate).buildAndExpand(uriVars).encode().toUri();
        return this.execute(webSocketHandler, null, uri);
    }

    @Override
    public final CompletableFuture<WebSocketSession> execute(WebSocketHandler webSocketHandler, @Nullable WebSocketHttpHeaders headers, URI uri) {
        Assert.notNull((Object)webSocketHandler, (String)"WebSocketHandler must not be null");
        this.assertUri(uri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting to " + String.valueOf(uri)));
        }
        HttpHeaders headersToUse = new HttpHeaders();
        if (headers != null) {
            headers.forEach((header, values) -> {
                if (values != null && !specialHeaders.contains(header.toLowerCase(Locale.ROOT))) {
                    headersToUse.put(header, values);
                }
            });
        }
        List<String> subProtocols = headers != null ? headers.getSecWebSocketProtocol() : Collections.emptyList();
        List<WebSocketExtension> extensions = headers != null ? headers.getSecWebSocketExtensions() : Collections.emptyList();
        return this.executeInternal(webSocketHandler, headersToUse, uri, subProtocols, extensions, Collections.emptyMap());
    }

    protected void assertUri(URI uri) {
        Assert.notNull((Object)uri, (String)"URI must not be null");
        String scheme = uri.getScheme();
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("Invalid scheme: " + scheme);
        }
    }

    protected abstract CompletableFuture<WebSocketSession> executeInternal(WebSocketHandler var1, HttpHeaders var2, URI var3, List<String> var4, List<WebSocketExtension> var5, Map<String, Object> var6);
}

