/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.stat.ip.path;

import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.TioConfig;
import org.tio.http.server.stat.DefaultStatPathFilter;
import org.tio.http.server.stat.StatPathFilter;
import org.tio.http.server.stat.ip.path.IpAccessStat;
import org.tio.http.server.stat.ip.path.IpPathAccessStatListener;
import org.tio.http.server.stat.ip.path.IpPathAccessStatRemovalListener;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.hutool.StrUtil;

public class IpPathAccessStats {
    private static Logger log = LoggerFactory.getLogger(IpPathAccessStats.class);
    private static final String CACHE_NAME = "TIO_IP_ACCESSPATH";
    private TioConfig tioConfig;
    private String tioConfigId;
    private StatPathFilter statPathFilter;
    public final Map<Long, CaffeineCache> cacheMap = new HashMap<Long, CaffeineCache>();
    public final List<Long> durationList = new ArrayList<Long>();
    private final Map<Long, IpPathAccessStatListener> listenerMap = new HashMap<Long, IpPathAccessStatListener>();

    public IpPathAccessStats(StatPathFilter statPathFilter, TioConfig tioConfig, IpPathAccessStatListener ipPathAccessStatListener, Long[] durations) {
        this.statPathFilter = statPathFilter;
        if (this.statPathFilter == null) {
            this.statPathFilter = DefaultStatPathFilter.me;
        }
        this.tioConfig = tioConfig;
        this.tioConfigId = tioConfig.getId();
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, ipPathAccessStatListener);
            }
        }
    }

    public void addDuration(Long duration, IpPathAccessStatListener ipPathAccessStatListener) {
        CaffeineCache caffeineCache = CaffeineCache.register((String)this.getCacheName(duration), (Long)duration, null, (RemovalListener)new IpPathAccessStatRemovalListener(this.tioConfig, ipPathAccessStatListener));
        this.cacheMap.put(duration, caffeineCache);
        this.durationList.add(duration);
        if (ipPathAccessStatListener != null) {
            this.listenerMap.put(duration, ipPathAccessStatListener);
        }
    }

    public IpPathAccessStatListener getListener(Long duration) {
        return this.listenerMap.get(duration);
    }

    public void addDurations(Long[] durations, IpPathAccessStatListener ipPathAccessStatListener) {
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, ipPathAccessStatListener);
            }
        }
    }

    public void removeMonitor(Long duration) {
        this.clear(duration);
        this.cacheMap.remove(duration);
        this.durationList.remove(duration);
    }

    public String getCacheName(Long duration) {
        String cacheName = "TIO_IP_ACCESSPATH_" + this.tioConfigId + "_";
        return cacheName + duration;
    }

    public void clear(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return;
        }
        caffeineCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpAccessStat get(Long duration, String ip, boolean forceCreate) {
        if (StrUtil.isBlank((CharSequence)ip)) {
            return null;
        }
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        IpAccessStat ipAccessStat = (IpAccessStat)caffeineCache.get(ip);
        if (ipAccessStat == null && forceCreate) {
            CaffeineCache caffeineCache2 = caffeineCache;
            synchronized (caffeineCache2) {
                ipAccessStat = (IpAccessStat)caffeineCache.get(ip);
                if (ipAccessStat == null) {
                    ipAccessStat = new IpAccessStat(duration, ip);
                    caffeineCache.put(ip, (Serializable)ipAccessStat);
                }
            }
        }
        return ipAccessStat;
    }

    public IpAccessStat get(Long duration, String ip) {
        return this.get(duration, ip, true);
    }

    public ConcurrentMap<String, Serializable> map(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        ConcurrentMap map = caffeineCache.asMap();
        return map;
    }

    public Long size(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        return caffeineCache.size();
    }

    public Collection<Serializable> values(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        Collection<Serializable> set = caffeineCache.asMap().values();
        return set;
    }

    public StatPathFilter getStatPathFilter() {
        return this.statPathFilter;
    }

    public void setStatPathFilter(StatPathFilter statPathFilter) {
        this.statPathFilter = statPathFilter;
    }
}

