/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Collection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PropertyDefinition
implements Comparable<PropertyDefinition> {
    private String name;
    private String defaultValue;
    private String description;
    private String displayName;
    private String type;
    private Boolean advanced;
    private Boolean masked;
    private Boolean required;
    private Collection<String> allowedValues;

    public PropertyDefinition(String name, String displayName, String description, String type, Boolean required, Boolean masked, Boolean advanced, String defaultValue, String[] allowedValues) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.required = required;
        this.masked = masked;
        this.advanced = advanced;
        if (allowedValues != null && allowedValues.length > 0) {
            this.allowedValues = Arrays.asList(allowedValues);
        }
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getAllowedValues() {
        return this.allowedValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public Boolean isAdvanced() {
        return this.advanced;
    }

    public Boolean isMasked() {
        return this.masked;
    }

    public Boolean isRequired() {
        return this.required;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Display Name:").append(this.getDisplayName());
        result.append(" Name:").append(this.getName());
        result.append(" Description:").append(this.getDescription());
        result.append(" Property Type Classname:").append(this.getType());
        result.append(" Default Value:").append(this.getDefaultValue());
        result.append(" Allowed Values:").append(this.getAllowedValues());
        result.append(" Required:").append(this.isRequired());
        result.append(" Expert:").append(this.isAdvanced());
        result.append(" Masked:").append(this.isMasked());
        return result.toString();
    }

    @Override
    public int compareTo(PropertyDefinition arg0) {
        if (arg0 == null) {
            return -1;
        }
        return this.name.compareToIgnoreCase(arg0.name);
    }
}

