/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.kafka;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.kafka.KafkaHelper;
import org.testcontainers.utility.DockerImageName;

public class ConfluentKafkaContainer
extends GenericContainer<ConfluentKafkaContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"confluentinc/cp-kafka");
    private final Set<String> listeners = new HashSet<String>();
    private final Set<Supplier<String>> advertisedListeners = new HashSet<Supplier<String>>();

    public ConfluentKafkaContainer(String imageName) {
        this(DockerImageName.parse((String)imageName));
    }

    public ConfluentKafkaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{9092});
        this.withEnv(KafkaHelper.envVars());
        this.withCommand(KafkaHelper.COMMAND);
        this.waitingFor(KafkaHelper.WAIT_STRATEGY);
    }

    protected void configure() {
        KafkaHelper.resolveListeners(this, this.listeners);
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        String brokerAdvertisedListener = String.format("BROKER://%s:%s", containerInfo.getConfig().getHostName(), "9093");
        ArrayList<String> advertisedListeners = new ArrayList<String>();
        advertisedListeners.add("PLAINTEXT://" + this.getBootstrapServers());
        advertisedListeners.add(brokerAdvertisedListener);
        advertisedListeners.addAll(KafkaHelper.resolveAdvertisedListeners(this.advertisedListeners));
        String kafkaAdvertisedListeners = String.join((CharSequence)",", advertisedListeners);
        String command = "#!/bin/bash\n";
        command = command + String.format("export KAFKA_ADVERTISED_LISTENERS=%s\n", kafkaAdvertisedListeners);
        command = command + "/etc/confluent/docker/run \n";
        this.copyFileToContainer(Transferable.of((String)command, (int)511), "/tmp/testcontainers_start.sh");
    }

    public ConfluentKafkaContainer withListener(String listener) {
        this.listeners.add(listener);
        this.advertisedListeners.add(() -> listener);
        return this;
    }

    public ConfluentKafkaContainer withListener(String listener, Supplier<String> advertisedListener) {
        this.listeners.add(listener);
        this.advertisedListeners.add(advertisedListener);
        return this;
    }

    public String getBootstrapServers() {
        return String.format("%s:%s", this.getHost(), this.getMappedPort(9092));
    }
}

