/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.LicenseAcceptance;
import org.testcontainers.utility.MountableFile;

public class Neo4jContainer<S extends Neo4jContainer<S>>
extends GenericContainer<S> {
    private static final String DEFAULT_IMAGE_NAME = "neo4j";
    private static final String DEFAULT_TAG = "3.5.0";
    private static final String DOCKER_IMAGE_NAME = "neo4j:3.5.0";
    private static final int DEFAULT_BOLT_PORT = 7687;
    private static final int DEFAULT_HTTPS_PORT = 7473;
    private static final int DEFAULT_HTTP_PORT = 7474;
    private static final String DEFAULT_ADMIN_PASSWORD = "password";
    private static final String AUTH_FORMAT = "neo4j/%s";
    private String adminPassword = "password";
    private boolean defaultImage = false;

    public Neo4jContainer() {
        this(DOCKER_IMAGE_NAME);
        this.defaultImage = true;
    }

    public Neo4jContainer(String dockerImageName) {
        super(dockerImageName);
        LogMessageWaitStrategy waitForBolt = new LogMessageWaitStrategy().withRegEx(String.format(".*Bolt enabled on 0\\.0\\.0\\.0:%d\\.\n", 7687));
        HttpWaitStrategy waitForHttp = new HttpWaitStrategy().forPort(7474).forStatusCodeMatching(response -> response == 200);
        this.waitStrategy = new WaitAllStrategy().withStrategy((WaitStrategy)waitForBolt).withStrategy((WaitStrategy)waitForHttp).withStartupTimeout(Duration.ofMinutes(2L));
        this.addExposedPorts(new int[]{7687, 7474, 7473});
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Stream.of(7687, 7474, 7473).map(arg_0 -> ((Neo4jContainer)this).getMappedPort(arg_0)).collect(Collectors.toSet());
    }

    protected void configure() {
        boolean emptyAdminPassword = this.adminPassword == null || this.adminPassword.isEmpty();
        String neo4jAuth = emptyAdminPassword ? "none" : String.format(AUTH_FORMAT, this.adminPassword);
        this.addEnv("NEO4J_AUTH", neo4jAuth);
    }

    public String getBoltUrl() {
        return String.format("bolt://" + this.getHost() + ":" + this.getMappedPort(7687), new Object[0]);
    }

    public String getHttpUrl() {
        return String.format("http://" + this.getHost() + ":" + this.getMappedPort(7474), new Object[0]);
    }

    public String getHttpsUrl() {
        return String.format("https://" + this.getHost() + ":" + this.getMappedPort(7473), new Object[0]);
    }

    public S withEnterpriseEdition() {
        if (!this.defaultImage) {
            throw new IllegalStateException(String.format("Cannot use enterprise version with alternative image %s.", this.getDockerImageName()));
        }
        this.setDockerImageName("neo4j:3.5.0-enterprise");
        LicenseAcceptance.assertLicenseAccepted((String)this.getDockerImageName());
        this.addEnv("NEO4J_ACCEPT_LICENSE_AGREEMENT", "yes");
        return (S)((Object)((Neo4jContainer)this.self()));
    }

    public S withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (S)((Object)((Neo4jContainer)this.self()));
    }

    public S withoutAuthentication() {
        return this.withAdminPassword(null);
    }

    public S withDatabase(MountableFile graphDb) {
        return (S)((Object)((Neo4jContainer)this.withCopyFileToContainer(graphDb, "/data/databases/graph.db")));
    }

    public S withPlugins(MountableFile plugins) {
        return (S)((Object)((Neo4jContainer)this.withCopyFileToContainer(plugins, "/var/lib/neo4j/plugins/")));
    }

    public S withNeo4jConfig(String key, String value) {
        this.addEnv(Neo4jContainer.formatConfigurationKey(key), value);
        return (S)((Object)((Neo4jContainer)this.self()));
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    private static String formatConfigurationKey(String plainConfigKey) {
        String prefix = "NEO4J_";
        return String.format("%s%s", "NEO4J_", plainConfigKey.replaceAll("_", "__").replaceAll("\\.", "_"));
    }
}

