/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import org.threeten.extra.chrono.AbstractDate;
import org.threeten.extra.chrono.JulianChronology;
import org.threeten.extra.chrono.JulianEra;

public final class JulianDate
extends AbstractDate
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -7920528871688876868L;
    private static final int JULIAN_0001_TO_ISO_1970 = 719164;
    private static final int DAYS_PER_CYCLE = 1461;
    private final int prolepticYear;
    private final short month;
    private final short day;

    public static JulianDate now() {
        return JulianDate.now(Clock.systemDefaultZone());
    }

    public static JulianDate now(ZoneId zone) {
        return JulianDate.now(Clock.system(zone));
    }

    public static JulianDate now(Clock clock) {
        LocalDate now = LocalDate.now(clock);
        return JulianDate.ofEpochDay(now.toEpochDay());
    }

    public static JulianDate of(int prolepticYear, int month, int dayOfMonth) {
        return JulianDate.create(prolepticYear, month, dayOfMonth);
    }

    public static JulianDate from(TemporalAccessor temporal) {
        if (temporal instanceof JulianDate) {
            return (JulianDate)temporal;
        }
        return JulianDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
    }

    static JulianDate ofYearDay(int prolepticYear, int dayOfYear) {
        JulianChronology.YEAR_RANGE.checkValidValue(prolepticYear, ChronoField.YEAR);
        ChronoField.DAY_OF_YEAR.checkValidValue(dayOfYear);
        boolean leap = JulianChronology.INSTANCE.isLeapYear(prolepticYear);
        if (dayOfYear == 366 && !leap) {
            throw new DateTimeException("Invalid date 'DayOfYear 366' as '" + prolepticYear + "' is not a leap year");
        }
        Month moy = Month.of((dayOfYear - 1) / 31 + 1);
        int monthEnd = moy.firstDayOfYear(leap) + moy.length(leap) - 1;
        if (dayOfYear > monthEnd) {
            moy = moy.plus(1L);
        }
        int dom = dayOfYear - moy.firstDayOfYear(leap) + 1;
        return new JulianDate(prolepticYear, moy.getValue(), dom);
    }

    static JulianDate ofEpochDay(long epochDay) {
        ChronoField.EPOCH_DAY.range().checkValidValue(epochDay, ChronoField.EPOCH_DAY);
        long julianEpochDay = epochDay + 719164L;
        long cycle = Math.floorDiv(julianEpochDay, 1461L);
        long daysInCycle = Math.floorMod(julianEpochDay, 1461L);
        if (daysInCycle == 1460L) {
            int year = (int)(cycle * 4L + 3L + 1L);
            return JulianDate.ofYearDay(year, 366);
        }
        int year = (int)(cycle * 4L + daysInCycle / 365L + 1L);
        int doy = (int)(daysInCycle % 365L + 1L);
        return JulianDate.ofYearDay(year, doy);
    }

    private static JulianDate resolvePreviousValid(int prolepticYear, int month, int day) {
        switch (month) {
            case 2: {
                day = Math.min(day, JulianChronology.INSTANCE.isLeapYear(prolepticYear) ? 29 : 28);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                day = Math.min(day, 30);
            }
        }
        return new JulianDate(prolepticYear, month, day);
    }

    static JulianDate create(int prolepticYear, int month, int dayOfMonth) {
        JulianChronology.YEAR_RANGE.checkValidValue(prolepticYear, ChronoField.YEAR);
        ChronoField.MONTH_OF_YEAR.checkValidValue(month);
        ChronoField.DAY_OF_MONTH.checkValidValue(dayOfMonth);
        if (dayOfMonth > 28) {
            int dom = 31;
            switch (month) {
                case 2: {
                    dom = JulianChronology.INSTANCE.isLeapYear(prolepticYear) ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    dom = 30;
                }
            }
            if (dayOfMonth > dom) {
                if (dayOfMonth == 29) {
                    throw new DateTimeException("Invalid date 'February 29' as '" + prolepticYear + "' is not a leap year");
                }
                throw new DateTimeException("Invalid date '" + Month.of(month).name() + " " + dayOfMonth + "'");
            }
        }
        return new JulianDate(prolepticYear, month, dayOfMonth);
    }

    private JulianDate(int prolepticYear, int month, int dayOfMonth) {
        this.prolepticYear = prolepticYear;
        this.month = (short)month;
        this.day = (short)dayOfMonth;
    }

    private Object readResolve() {
        return JulianDate.create(this.prolepticYear, this.month, this.day);
    }

    @Override
    int getProlepticYear() {
        return this.prolepticYear;
    }

    @Override
    int getMonth() {
        return this.month;
    }

    @Override
    int getDayOfMonth() {
        return this.day;
    }

    @Override
    int getDayOfYear() {
        return Month.of(this.month).firstDayOfYear(this.isLeapYear()) + this.day - 1;
    }

    @Override
    AbstractDate withDayOfYear(int value) {
        return this.plusDays(value - this.getDayOfYear());
    }

    @Override
    ValueRange rangeAlignedWeekOfMonth() {
        return ValueRange.of(1L, this.month == 2 && !this.isLeapYear() ? 4L : 5L);
    }

    @Override
    JulianDate resolvePrevious(int newYear, int newMonth, int dayOfMonth) {
        return JulianDate.resolvePreviousValid(newYear, newMonth, dayOfMonth);
    }

    @Override
    public JulianChronology getChronology() {
        return JulianChronology.INSTANCE;
    }

    @Override
    public JulianEra getEra() {
        return this.prolepticYear >= 1 ? JulianEra.AD : JulianEra.BC;
    }

    @Override
    public int lengthOfMonth() {
        switch (this.month) {
            case 2: {
                return this.isLeapYear() ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    @Override
    public JulianDate with(TemporalAdjuster adjuster) {
        return (JulianDate)adjuster.adjustInto(this);
    }

    @Override
    public JulianDate with(TemporalField field, long newValue) {
        return (JulianDate)super.with(field, newValue);
    }

    @Override
    public JulianDate plus(TemporalAmount amount) {
        return (JulianDate)amount.addTo(this);
    }

    @Override
    public JulianDate plus(long amountToAdd, TemporalUnit unit) {
        return (JulianDate)super.plus(amountToAdd, unit);
    }

    @Override
    public JulianDate minus(TemporalAmount amount) {
        return (JulianDate)amount.subtractFrom(this);
    }

    @Override
    public JulianDate minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public ChronoLocalDateTime<JulianDate> atTime(LocalTime localTime) {
        return ChronoLocalDate.super.atTime(localTime);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        return super.until(JulianDate.from(endExclusive), unit);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate endDateExclusive) {
        return super.until(JulianDate.from(endDateExclusive));
    }

    @Override
    public long toEpochDay() {
        long year = this.prolepticYear;
        long julianEpochDay = (year - 1L) * 365L + Math.floorDiv(year - 1L, 4L) + (long)(this.getDayOfYear() - 1);
        return julianEpochDay - 719164L;
    }
}

