/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.glossary;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.zanata.adapter.glossary.AbstractGlossaryPushReader;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.Glossary;
import org.zanata.rest.dto.GlossaryEntry;
import org.zanata.rest.dto.GlossaryTerm;

public class GlossaryCSVReader
extends AbstractGlossaryPushReader {
    private final int batchSize;
    private final List<String> customColNames;

    public GlossaryCSVReader(List<String> customColNames, int batchSize) {
        this.customColNames = customColNames;
        this.batchSize = batchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Glossary> extractGlossary(Reader reader) throws IOException {
        int entryCount = 0;
        CSVReader csvReader = new CSVReader(reader);
        try {
            ArrayList<Glossary> glossaries = new ArrayList<Glossary>();
            List entries = csvReader.readAll();
            this.validateCVSEntries(entries);
            Map<Integer, String> descriptionMap = this.setupDescMap(entries);
            Map<Integer, LocaleId> localeColMap = this.setupLocalesMap(entries, descriptionMap);
            LocaleId srcLocale = localeColMap.get(0);
            Glossary glossary = new Glossary();
            for (int i = 1; i < entries.size(); ++i) {
                String[] row = (String[])entries.get(i);
                GlossaryEntry entry = new GlossaryEntry();
                entry.setSrcLang(srcLocale);
                for (int x = 0; x < row.length && localeColMap.containsKey(x); ++x) {
                    GlossaryTerm term = new GlossaryTerm();
                    term.setLocale(localeColMap.get(x));
                    term.setContent(row[x]);
                    if (x == 0) {
                        for (int descRow : descriptionMap.keySet()) {
                            term.getComments().add(row[descRow]);
                        }
                    }
                    entry.getGlossaryTerms().add(term);
                }
                glossary.getGlossaryEntries().add(entry);
                if (++entryCount != this.batchSize && i != entries.size() - 1) continue;
                glossaries.add(glossary);
                entryCount = 0;
                glossary = new Glossary();
            }
            ArrayList<Glossary> arrayList = glossaries;
            return arrayList;
        }
        finally {
            csvReader.close();
        }
    }

    private void validateCVSEntries(List<String[]> entries) {
        if (entries.isEmpty() || entries == null) {
            throw new RuntimeException("Invalid CSV file - empty file");
        }
        if (entries.size() < 2) {
            throw new RuntimeException("Invalid CSV file - no entries found");
        }
        for (String[] row : entries) {
            if (entries.get(0).length == row.length) continue;
            throw new RuntimeException("Invalid CSV file - inconsistency of columns with header");
        }
    }

    private Map<Integer, LocaleId> setupLocalesMap(List<String[]> entries, Map<Integer, String> descriptionMap) {
        HashMap<Integer, LocaleId> localeColMap = new HashMap<Integer, LocaleId>();
        String[] headerRow = entries.get(0);
        for (int row = 0; row < headerRow.length && !descriptionMap.containsKey(row); ++row) {
            LocaleId locale = new LocaleId(headerRow[row]);
            localeColMap.put(row, locale);
        }
        return localeColMap;
    }

    private Map<Integer, String> setupDescMap(List<String[]> entries) {
        HashMap<Integer, String> descMap = new HashMap<Integer, String>();
        String[] headerRow = entries.get(0);
        for (int row = 0; row < headerRow.length; ++row) {
            for (String optsHeader : this.customColNames) {
                if (!optsHeader.equals(headerRow[row])) continue;
                descMap.put(row, headerRow[row]);
            }
        }
        ValueComparator bvc = new ValueComparator(descMap);
        TreeMap<Integer, String> sorted_map = new TreeMap<Integer, String>(bvc);
        sorted_map.putAll(descMap);
        return sorted_map;
    }

    static class ValueComparator
    implements Comparator<Integer> {
        Map<Integer, String> base;

        public ValueComparator(Map<Integer, String> base) {
            this.base = base;
        }

        @Override
        public int compare(Integer a, Integer b) {
            String strA = this.base.get(a);
            String strB = this.base.get(b);
            if (strA == null || strB == null) {
                return strA == null ? -1 : 1;
            }
            return strA.compareTo(strB);
        }
    }
}

