/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.glossary;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang.StringUtils;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.catalog.parse.MessageStreamParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.zanata.adapter.glossary.AbstractGlossaryPushReader;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.Glossary;
import org.zanata.rest.dto.GlossaryEntry;
import org.zanata.rest.dto.GlossaryTerm;

public class GlossaryPoReader
extends AbstractGlossaryPushReader {
    private static final Logger log = LoggerFactory.getLogger(GlossaryPoReader.class);
    private final LocaleId srcLang;
    private final LocaleId transLang;
    private final int batchSize;
    private final boolean treatSourceCommentsAsTarget;

    public GlossaryPoReader(LocaleId srcLang, LocaleId transLang, boolean treatSourceCommentsAsTarget, int batchSize) {
        this.srcLang = srcLang;
        this.transLang = transLang;
        this.batchSize = batchSize;
        this.treatSourceCommentsAsTarget = treatSourceCommentsAsTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Glossary> extractGlossary(Reader reader) throws IOException {
        ReaderInputStream ris = new ReaderInputStream(reader);
        try {
            InputSource potInputSource = new InputSource((InputStream)ris);
            potInputSource.setEncoding("utf8");
            List<Glossary> list = this.extractTemplate(potInputSource);
            return list;
        }
        finally {
            ris.close();
        }
    }

    private List<Glossary> extractTemplate(InputSource potInputSource) {
        int entryCount = 0;
        MessageStreamParser messageParser = GlossaryPoReader.createParser(potInputSource);
        ArrayList<Glossary> glossaries = new ArrayList<Glossary>();
        Glossary glossary = new Glossary();
        while (messageParser.hasNext()) {
            Message message = messageParser.next();
            if (!(message.isHeader() || message.isObsolete() || message.isPlural())) {
                if (message.isFuzzy()) {
                    log.warn("term: [{}] is ignored - state fuzzy", (Object)message.getMsgid());
                } else {
                    GlossaryEntry entry = new GlossaryEntry();
                    entry.setSrcLang(this.srcLang);
                    GlossaryTerm srcTerm = new GlossaryTerm();
                    srcTerm.setLocale(this.srcLang);
                    srcTerm.setContent(message.getMsgid());
                    GlossaryTerm targetTerm = new GlossaryTerm();
                    targetTerm.setLocale(this.transLang);
                    targetTerm.setContent(message.getMsgstr());
                    if (this.treatSourceCommentsAsTarget) {
                        for (String srcRef : message.getSourceReferences()) {
                            targetTerm.getComments().add(srcRef);
                        }
                        for (String comment : message.getExtractedComments()) {
                            targetTerm.getComments().add(comment);
                        }
                    } else {
                        StringBuilder sb = new StringBuilder();
                        if (!StringUtils.isEmpty((String)entry.getSourcereference())) {
                            sb.append(entry.getSourcereference());
                        }
                        if (!StringUtils.isEmpty((String)StringUtils.join((Collection)message.getSourceReferences(), (String)"\n"))) {
                            sb.append(StringUtils.join((Collection)message.getSourceReferences(), (String)"\n"));
                        }
                        entry.setSourcereference(sb.toString());
                        for (String comment : message.getExtractedComments()) {
                            srcTerm.getComments().add(comment);
                        }
                    }
                    for (String comment : message.getComments()) {
                        targetTerm.getComments().add(comment);
                    }
                    entry.getGlossaryTerms().add(srcTerm);
                    entry.getGlossaryTerms().add(targetTerm);
                    glossary.getGlossaryEntries().add(entry);
                    ++entryCount;
                }
            }
            if (entryCount != this.batchSize && messageParser.hasNext()) continue;
            glossaries.add(glossary);
            entryCount = 0;
            glossary = new Glossary();
        }
        return glossaries;
    }

    static MessageStreamParser createParser(InputSource inputSource) {
        MessageStreamParser messageParser;
        if (inputSource.getCharacterStream() != null) {
            messageParser = new MessageStreamParser(inputSource.getCharacterStream());
        } else if (inputSource.getByteStream() != null) {
            messageParser = inputSource.getEncoding() != null ? new MessageStreamParser(inputSource.getByteStream(), Charset.forName(inputSource.getEncoding())) : new MessageStreamParser(inputSource.getByteStream(), Charset.forName("UTF-8"));
        } else if (inputSource.getSystemId() != null) {
            try {
                URL url = new URL(inputSource.getSystemId());
                if (inputSource.getEncoding() != null) {
                    messageParser = new MessageStreamParser(url.openStream(), Charset.forName(inputSource.getEncoding()));
                }
                messageParser = new MessageStreamParser(url.openStream(), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                throw new RuntimeException("failed to get input from url in inputSource", e);
            }
        } else {
            throw new RuntimeException("not a valid inputSource");
        }
        return messageParser;
    }
}

