/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.xliff;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zanata.adapter.xliff.XliffCommon;
import org.zanata.common.ContentState;
import org.zanata.common.ContentType;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.ExtensionValue;
import org.zanata.rest.dto.extensions.comment.SimpleComment;
import org.zanata.rest.dto.resource.ExtensionSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;

public class XliffReader
extends XliffCommon {
    private final SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final XMLInputFactory xmlif = XMLInputFactory.newInstance();
    private LocaleId srcLang;
    private XliffCommon.ValidationType validationType;

    public Resource extractTemplate(File file, LocaleId sourceLocaleId, String docName, String validationType) throws FileNotFoundException {
        Resource document = new Resource(docName);
        document.setContentType(ContentType.TextPlain);
        document.setLang(sourceLocaleId);
        this.srcLang = sourceLocaleId;
        this.validationType = XliffCommon.ValidationType.valueOf(validationType.toUpperCase());
        this.extractXliff(file, document, null);
        return document;
    }

    public TranslationsResource extractTarget(File file) throws FileNotFoundException {
        TranslationsResource document = new TranslationsResource();
        this.extractXliff(file, null, document);
        return document;
    }

    private void validateXliffFile(InputSource inputSource) {
        try {
            XMLStreamReader xmlr = this.xmlif.createXMLStreamReader(inputSource.getByteStream());
            StreamSource schemaSource = new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/xliff-core-1.1.xsd"));
            this.factory.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("schema/" + systemId);
                    return new Input(publicId, systemId, resourceAsStream);
                }
            });
            Schema schema = this.factory.newSchema(schemaSource);
            Validator validator = schema.newValidator();
            validator.validate(new StAXSource(xmlr));
            xmlr.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Invalid XLIFF file format  ", e);
        }
        catch (SAXException saxException) {
            throw new RuntimeException("Invalid XLIFF file format  ", saxException);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Invalid XLIFF file format  ", ioException);
        }
    }

    private void extractXliff(File file, Resource document, TranslationsResource transDoc) throws FileNotFoundException {
        InputSource inputSource;
        if (this.validationType == XliffCommon.ValidationType.XSD) {
            inputSource = new InputSource(new FileInputStream(file));
            inputSource.setEncoding("utf8");
            this.validateXliffFile(new InputSource(new FileInputStream(file)));
        }
        try {
            this.xmlif.setProperty("javax.xml.stream.isCoalescing", true);
            inputSource = new InputSource(new FileInputStream(file));
            inputSource.setEncoding("utf8");
            XMLStreamReader xmlr = this.xmlif.createXMLStreamReader(inputSource.getByteStream());
            while (xmlr.hasNext()) {
                xmlr.next();
                if (xmlr.getEventType() == 5 || xmlr.isStartElement() && XliffReader.getLocalName(xmlr).equals("file")) continue;
                if (xmlr.isStartElement() && XliffReader.getLocalName(xmlr).equals("trans-unit")) {
                    if (document != null) {
                        TextFlow textFlow = this.extractTransUnit(xmlr);
                        if (textFlow == null) continue;
                        document.getTextFlows().add(textFlow);
                        continue;
                    }
                    TextFlowTarget tfTarget = this.extractTransUnitTarget(xmlr);
                    List contents = tfTarget.getContents();
                    boolean targetEmpty = contents.isEmpty() || StringUtils.isEmpty((String)((String)contents.get(0)));
                    if (targetEmpty) continue;
                    tfTarget.setState(ContentState.Approved);
                    transDoc.getTextFlowTargets().add(tfTarget);
                    continue;
                }
                if (!xmlr.isEndElement() || !XliffReader.getLocalName(xmlr).equals("file")) continue;
            }
            xmlr.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Invalid XLIFF file format  ", e);
        }
    }

    private TextFlow extractTransUnit(XMLStreamReader xmlr) throws XMLStreamException {
        TextFlow textFlow = new TextFlow();
        Boolean endTransUnit = false;
        String id = this.getAttributeValue(xmlr, "id");
        textFlow.setId(id);
        while (xmlr.hasNext() && !endTransUnit.booleanValue()) {
            xmlr.next();
            String localName = XliffReader.getLocalName(xmlr);
            boolean endElement = xmlr.isEndElement();
            if (endElement && localName.equals("trans-unit")) {
                endTransUnit = true;
                continue;
            }
            boolean startElement = xmlr.isStartElement();
            if (startElement && localName.equals("source")) {
                String content = this.getElementValue(xmlr, "source", XliffReader.getContentElementList());
                textFlow.setContents(new String[]{content});
                continue;
            }
            if (!startElement || !localName.equals("context-group")) continue;
            textFlow.getExtensions(true).addAll(this.extractContextList(xmlr));
        }
        textFlow.setLang(this.srcLang);
        return textFlow;
    }

    private TextFlowTarget extractTransUnitTarget(XMLStreamReader xmlr) throws XMLStreamException {
        TextFlowTarget textFlowTarget = new TextFlowTarget();
        Boolean endTransUnit = false;
        textFlowTarget.setResId(this.getAttributeValue(xmlr, "id"));
        while (xmlr.hasNext() && !endTransUnit.booleanValue()) {
            xmlr.next();
            boolean endElement = xmlr.isEndElement();
            String localName = XliffReader.getLocalName(xmlr);
            if (endElement && localName.equals("trans-unit")) {
                endTransUnit = true;
                continue;
            }
            if (xmlr.isStartElement() && localName.equals("target")) {
                String content = this.getElementValue(xmlr, "target", XliffReader.getContentElementList());
                textFlowTarget.setContents(Arrays.asList(content));
                continue;
            }
            if (!xmlr.isStartElement() || !localName.equals("context-group")) continue;
            textFlowTarget.getExtensions(true).addAll(this.extractContextList(xmlr));
        }
        return textFlowTarget;
    }

    private ExtensionSet<SimpleComment> extractContextList(XMLStreamReader xmlr) throws XMLStreamException {
        ExtensionSet contextList = new ExtensionSet();
        Boolean endContextGroup = false;
        String contextGroup = this.getAttributeValue(xmlr, "name");
        while (xmlr.hasNext() && !endContextGroup.booleanValue()) {
            xmlr.next();
            String localName = XliffReader.getLocalName(xmlr);
            boolean endElement = xmlr.isEndElement();
            if (endElement && localName.equals("context-group")) {
                endContextGroup = true;
                continue;
            }
            boolean startElement = xmlr.isStartElement();
            if (!startElement || !localName.equals("context")) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(contextGroup);
            sb.append("::");
            sb.append(this.getAttributeValue(xmlr, "context-type"));
            sb.append("::");
            sb.append(this.getElementValue(xmlr, "context", null));
            contextList.add((ExtensionValue)new SimpleComment(sb.toString()));
        }
        return contextList;
    }

    private String getElementValue(XMLStreamReader reader, String elementName, Collection<String> legalElements) throws XMLStreamException {
        boolean keepReading = true;
        StringBuilder contents = new StringBuilder();
        reader.next();
        String localName = XliffReader.getLocalName(reader);
        if ((reader.isEndElement() || reader.isStartElement()) && localName.equals(elementName)) {
            keepReading = false;
        }
        while (keepReading) {
            if (reader.hasText()) {
                contents.append(reader.getText());
            } else if (reader.isStartElement() || reader.isEndElement()) {
                if (legalElements == null || legalElements.contains(localName)) {
                    throw new RuntimeException("Sorry, Zanata does not support elements inside " + elementName + ": " + localName);
                }
                throw new RuntimeException("Invalid XLIFF: " + localName + " is not legal inside " + elementName);
            }
            reader.next();
            localName = XliffReader.getLocalName(reader);
            if (!reader.isEndElement() && !reader.isStartElement() || !localName.equals(elementName)) continue;
            keepReading = false;
        }
        return contents.toString();
    }

    private static String getLocalName(XMLStreamReader xmlr) {
        if (xmlr.isCharacters()) {
            return "";
        }
        return xmlr.getLocalName();
    }

    private String getAttributeValue(XMLStreamReader xmlr, String attrKey) {
        int count = xmlr.getAttributeCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                if (!xmlr.getAttributeLocalName(i).equals(attrKey)) continue;
                return xmlr.getAttributeValue(i);
            }
        }
        return null;
    }

    public class Input
    implements LSInput {
        private String publicId;
        private String systemId;
        private BufferedInputStream inputStream;

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.inputStream;
            synchronized (bufferedInputStream) {
                try {
                    byte[] input = new byte[this.inputStream.available()];
                    this.inputStream.read(input);
                    String contents = new String(input);
                    return contents;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("Exception " + e);
                    return null;
                }
            }
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public BufferedInputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(BufferedInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public Input(String publicId, String sysId, InputStream input) {
            this.publicId = publicId;
            this.systemId = sysId;
            this.inputStream = new BufferedInputStream(input);
        }
    }
}

