/*
 * Decompiled with CFR 0.152.
 */
package pt.kcry.blake3;

import pt.kcry.blake3.ChunkState$;
import pt.kcry.blake3.CommonFunction$;
import pt.kcry.blake3.Output;
import pt.kcry.blake3.package$;

public class ChunkState {
    private final int[] key;
    private long chunkCounter;
    private final int flags;
    private final int[] chainingValue;
    private final byte[] block;
    private int blockLen;
    private int blocksCompressed;
    private final int[] tmpBlockWords;
    private final int[] tmpState;

    public static int[] zerosBlockWords() {
        return ChunkState$.MODULE$.zerosBlockWords();
    }

    public ChunkState(int[] key, long chunkCounter, int flags) {
        this.key = key;
        this.chunkCounter = chunkCounter;
        this.flags = flags;
        this.chainingValue = new int[package$.MODULE$.BLOCK_LEN_WORDS()];
        System.arraycopy(key, 0, this.chainingValue(), 0, package$.MODULE$.KEY_LEN_WORDS());
        this.block = new byte[package$.MODULE$.BLOCK_LEN()];
        this.blockLen = 0;
        this.blocksCompressed = 0;
        this.tmpBlockWords = new int[package$.MODULE$.BLOCK_LEN_WORDS()];
        this.tmpState = new int[package$.MODULE$.BLOCK_LEN_WORDS()];
    }

    public int[] key() {
        return this.key;
    }

    public long chunkCounter() {
        return this.chunkCounter;
    }

    public void chunkCounter_$eq(long x$1) {
        this.chunkCounter = x$1;
    }

    public int flags() {
        return this.flags;
    }

    public int[] chainingValue() {
        return this.chainingValue;
    }

    public byte[] block() {
        return this.block;
    }

    public int blockLen() {
        return this.blockLen;
    }

    public void blockLen_$eq(int x$1) {
        this.blockLen = x$1;
    }

    public int blocksCompressed() {
        return this.blocksCompressed;
    }

    public void blocksCompressed_$eq(int x$1) {
        this.blocksCompressed = x$1;
    }

    public long reset(int[] key) {
        System.arraycopy(key, 0, this.chainingValue(), 0, package$.MODULE$.KEY_LEN_WORDS());
        this.chunkCounter_$eq(this.chunkCounter() + 1L);
        this.blockLen_$eq(0);
        this.blocksCompressed_$eq(0);
        return this.chunkCounter();
    }

    public int len() {
        return package$.MODULE$.BLOCK_LEN() * this.blocksCompressed() + this.blockLen();
    }

    private int startFlag() {
        return this.blocksCompressed() == 0 ? package$.MODULE$.CHUNK_START() : 0;
    }

    private void compressedWords(byte[] bytes, int bytesOffset) {
        CommonFunction$.MODULE$.compressInPlace(this.chainingValue(), bytes, bytesOffset, this.chunkCounter(), package$.MODULE$.BLOCK_LEN(), this.flags() | this.startFlag(), this.tmpState, this.tmpBlockWords);
        this.blocksCompressed_$eq(this.blocksCompressed() + 1);
        this.blockLen_$eq(0);
    }

    private void compressIfRequired() {
        if (this.blockLen() == package$.MODULE$.BLOCK_LEN()) {
            this.compressedWords(this.block(), 0);
        }
    }

    public void update(byte[] bytes, int from, int to) {
        int i = from;
        int available = package$.MODULE$.BLOCK_LEN() - this.blockLen();
        int consume = Math.min(available, to - i);
        if (consume > 0) {
            System.arraycopy(bytes, i, this.block(), this.blockLen(), consume);
            this.blockLen_$eq(this.blockLen() + consume);
            i += consume;
        }
        if ((consume = to - i) > 0) {
            this.compressIfRequired();
        }
        while (consume > package$.MODULE$.BLOCK_LEN()) {
            this.blockLen_$eq(package$.MODULE$.BLOCK_LEN());
            this.compressedWords(bytes, i);
            consume = to - (i += package$.MODULE$.BLOCK_LEN());
        }
        if (consume > 0) {
            System.arraycopy(bytes, i, this.block(), this.blockLen(), consume);
            this.blockLen_$eq(this.blockLen() + consume);
        }
    }

    public void update(byte by) {
        this.compressIfRequired();
        this.block()[this.blockLen()] = by;
        this.blockLen_$eq(this.blockLen() + 1);
    }

    private void roundBlock(int[] blockWords) {
        int off = 0;
        int i = 0;
        while (off < this.blockLen()) {
            int n = this.blockLen() - off;
            switch (n) {
                case 1: {
                    blockWords[i] = this.block()[off] & 0xFF;
                    break;
                }
                case 2: {
                    blockWords[i] = (this.block()[off + 1] & 0xFF) << 8 | this.block()[off] & 0xFF;
                    break;
                }
                case 3: {
                    blockWords[i] = (this.block()[off + 2] & 0xFF) << 16 | (this.block()[off + 1] & 0xFF) << 8 | this.block()[off] & 0xFF;
                    break;
                }
                default: {
                    blockWords[i] = (this.block()[off + 3] & 0xFF) << 24 | (this.block()[off + 2] & 0xFF) << 16 | (this.block()[off + 1] & 0xFF) << 8 | this.block()[off] & 0xFF;
                    break;
                }
            }
            off += 4;
            ++i;
        }
        int zeros = package$.MODULE$.BLOCK_LEN_WORDS() - i;
        if (zeros > 0) {
            System.arraycopy(ChunkState$.MODULE$.zerosBlockWords(), 0, blockWords, i, zeros);
        }
    }

    public Output unsafeOutput() {
        this.roundBlock(this.tmpBlockWords);
        return new Output(this.chainingValue(), this.tmpBlockWords, this.chunkCounter(), this.blockLen(), this.flags() | this.startFlag() | package$.MODULE$.CHUNK_END());
    }

    public Output output() {
        int[] safeChainingValue = new int[package$.MODULE$.KEY_LEN_WORDS()];
        System.arraycopy(this.chainingValue(), 0, safeChainingValue, 0, package$.MODULE$.KEY_LEN_WORDS());
        int[] safeBlockWords = new int[package$.MODULE$.BLOCK_LEN_WORDS()];
        this.roundBlock(safeBlockWords);
        return new Output(safeChainingValue, safeBlockWords, this.chunkCounter(), this.blockLen(), this.flags() | this.startFlag() | package$.MODULE$.CHUNK_END());
    }
}

