/*
 * Decompiled with CFR 0.152.
 */
package pt.kcry.blake3;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import pt.kcry.blake3.RFC4648$;
import scala.math.BigInt;
import scala.package$;

public interface Hasher {
    public Hasher update(byte[] var1);

    public Hasher update(byte[] var1, int var2, int var3);

    public Hasher update(byte var1);

    public Hasher update(short var1);

    public Hasher update(int var1);

    public Hasher update(long var1);

    public Hasher update(String var1);

    public Hasher update(InputStream var1, int var2);

    public static Hasher update$(Hasher $this, InputStream input) {
        return $this.update(input);
    }

    default public Hasher update(InputStream input) {
        return this.update(input, Integer.MAX_VALUE);
    }

    public Hasher update(ByteBuffer var1, int var2);

    public static Hasher update$(Hasher $this, ByteBuffer input) {
        return $this.update(input);
    }

    default public Hasher update(ByteBuffer input) {
        return this.update(input, input.remaining());
    }

    public void done(byte[] var1);

    public void done(byte[] var1, int var2, int var3);

    public static byte[] done$(Hasher $this, int len) {
        return $this.done(len);
    }

    /*
     * WARNING - void declaration
     */
    default public byte[] done(int len) {
        void var2_2;
        byte[] bytes = new byte[len];
        this.done(bytes);
        return var2_2;
    }

    public byte done();

    public void done(OutputStream var1, int var2);

    public void done(ByteBuffer var1, int var2);

    public static void done$(Hasher $this, ByteBuffer out) {
        $this.done(out);
    }

    default public void done(ByteBuffer out) {
        this.done(out, out.remaining());
    }

    public short doneShort();

    public int doneInt();

    public long doneLong();

    public void doneXor(byte[] var1);

    public void doneXor(byte[] var1, int var2, byte[] var3, int var4, int var5);

    public void doneXor(InputStream var1, OutputStream var2, int var3);

    public void doneXor(ByteBuffer var1, ByteBuffer var2, int var3);

    public static BigInt doneBigInt$(Hasher $this, int bitLength) {
        return $this.doneBigInt(bitLength);
    }

    default public BigInt doneBigInt(int bitLength) throws IllegalArgumentException {
        if (bitLength % 8 != 0) {
            throw new IllegalArgumentException(new StringBuilder(37).append("bitLength: ").append(bitLength).append(" should be a multiple of 8").toString());
        }
        return package$.MODULE$.BigInt().apply(1, this.done(bitLength / 8));
    }

    public static BigInt doneBigInt$(Hasher $this, BigInt N) {
        return $this.doneBigInt(N);
    }

    default public BigInt doneBigInt(BigInt N) {
        int n;
        int n2 = N.bitLength();
        int bitLength = n2;
        if (bitLength % 8 == 0) {
            n = bitLength / 8;
        } else {
            int bitLength2 = n2;
            n = bitLength2 / 8 + 1;
        }
        int bytes = n;
        return package$.MODULE$.BigInt().apply(1, this.done(bytes)).mod(N);
    }

    public static String doneHex$(Hasher $this, int resultLength) {
        return $this.doneHex(resultLength);
    }

    default public String doneHex(int resultLength) throws IllegalArgumentException {
        if (resultLength % 2 != 0) {
            throw new IllegalArgumentException(new StringBuilder(29).append("resultLength: ").append(resultLength).append(" should be even").toString());
        }
        return RFC4648$.MODULE$.base16(this.done(resultLength / 2)).toLowerCase();
    }

    public static String doneBase16$(Hasher $this, int len) {
        return $this.doneBase16(len);
    }

    default public String doneBase16(int len) {
        return RFC4648$.MODULE$.base16(this.done(len));
    }

    public static String doneBase32$(Hasher $this, int len) {
        return $this.doneBase32(len);
    }

    default public String doneBase32(int len) {
        return RFC4648$.MODULE$.base32(this.done(len));
    }

    public static String doneBase32Hex$(Hasher $this, int len) {
        return $this.doneBase32Hex(len);
    }

    default public String doneBase32Hex(int len) {
        return RFC4648$.MODULE$.base32_hex(this.done(len));
    }

    public static String doneBase64$(Hasher $this, int len) {
        return $this.doneBase64(len);
    }

    default public String doneBase64(int len) {
        return RFC4648$.MODULE$.base64(this.done(len));
    }

    public static String doneBase64Url$(Hasher $this, int len) {
        return $this.doneBase64Url(len);
    }

    default public String doneBase64Url(int len) {
        return RFC4648$.MODULE$.base64_url(this.done(len));
    }

    public static void write$(Hasher $this, int b) {
        $this.write(b);
    }

    default public void write(int b) {
        this.update((byte)b);
    }

    public static void write$(Hasher $this, byte[] b) {
        $this.write(b);
    }

    default public void write(byte[] b) {
        this.update(b);
    }

    public static void write$(Hasher $this, byte[] b, int off, int len) {
        $this.write(b, off, len);
    }

    default public void write(byte[] b, int off, int len) {
        this.update(b, off, len);
    }
}

