/*
 * Decompiled with CFR 0.152.
 */
package pt.kcry.blake3;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import pt.kcry.blake3.ChunkState;
import pt.kcry.blake3.CommonFunction$;
import pt.kcry.blake3.Hasher;
import pt.kcry.blake3.Output;
import pt.kcry.blake3.package$;

public class HasherImpl
extends OutputStream
implements Hasher {
    private final int[] key;
    private final int flags;
    private final ChunkState chunkState;
    private final int[][] cvStack;
    private int cvStackLen;
    private final int[] tmpBlockWords;

    public HasherImpl(int[] key, int flags) {
        this.key = key;
        this.flags = flags;
        this.chunkState = new ChunkState(key, 0L, flags);
        this.cvStack = new int[package$.MODULE$.MAX_DEPTH()][];
        this.cvStackLen = 0;
        this.tmpBlockWords = new int[package$.MODULE$.BLOCK_LEN_WORDS()];
    }

    public int[] key() {
        return this.key;
    }

    public int flags() {
        return this.flags;
    }

    public ChunkState chunkState() {
        return this.chunkState;
    }

    public int[][] cvStack() {
        return this.cvStack;
    }

    public int cvStackLen() {
        return this.cvStackLen;
    }

    public void cvStackLen_$eq(int x$1) {
        this.cvStackLen = x$1;
    }

    private void pushStack(int[] cv) {
        this.cvStack()[this.cvStackLen()] = cv;
        this.cvStackLen_$eq(this.cvStackLen() + 1);
    }

    private int[] popStack() {
        this.cvStackLen_$eq(this.cvStackLen() - 1);
        return this.cvStack()[this.cvStackLen()];
    }

    private void addChunkChainingValue(int[] cv, long chunks) {
        long totalChunks = chunks;
        while ((totalChunks & 1L) == 0L) {
            CommonFunction$.MODULE$.parentCV(cv, this.popStack(), cv, this.key(), this.flags(), this.tmpBlockWords);
            totalChunks >>= 1;
        }
        this.pushStack(cv);
    }

    /*
     * WARNING - void declaration
     */
    private int finalizeWhenCompleted() {
        boolean bl;
        int len = this.chunkState().len();
        if (len == package$.MODULE$.CHUNK_LEN()) {
            int[] chunkCV = new int[package$.MODULE$.BLOCK_LEN_WORDS()];
            this.chunkState().unsafeOutput().chainingValue(chunkCV);
            long totalChunks = this.chunkState().reset(this.key());
            this.addChunkChainingValue(chunkCV, totalChunks);
            bl = false;
        } else {
            void var1_1;
            bl = var1_1;
        }
        return bl ? 1 : 0;
    }

    @Override
    public Hasher update(byte[] input, int offset, int len) {
        HasherImpl hasherImpl;
        HasherImpl hasherImpl2 = this;
        synchronized (hasherImpl2) {
            int consume;
            int end = offset + len;
            for (int i = offset; i < end; i += consume) {
                int len2 = this.finalizeWhenCompleted();
                consume = Math.min(package$.MODULE$.CHUNK_LEN() - len2, end - i);
                this.chunkState().update(input, i, i + consume);
            }
            hasherImpl = this;
        }
        return hasherImpl;
    }

    @Override
    public Hasher update(byte[] input) {
        return this.update(input, 0, input.length);
    }

    @Override
    public Hasher update(String input) {
        return this.update(input.getBytes());
    }

    @Override
    public Hasher update(byte input) {
        HasherImpl hasherImpl;
        HasherImpl hasherImpl2 = this;
        synchronized (hasherImpl2) {
            this.finalizeWhenCompleted();
            this.chunkState().update(input);
            hasherImpl = this;
        }
        return hasherImpl;
    }

    @Override
    public Hasher update(short input) {
        HasherImpl hasherImpl;
        HasherImpl hasherImpl2 = this;
        synchronized (hasherImpl2) {
            short v = input;
            for (int i = 0; i < 2; ++i) {
                this.finalizeWhenCompleted();
                this.chunkState().update((byte)v);
                v = (short)(v >> 8);
            }
            hasherImpl = this;
        }
        return hasherImpl;
    }

    @Override
    public Hasher update(int input) {
        HasherImpl hasherImpl;
        HasherImpl hasherImpl2 = this;
        synchronized (hasherImpl2) {
            int v = input;
            for (int i = 0; i < 4; ++i) {
                this.finalizeWhenCompleted();
                this.chunkState().update((byte)v);
                v >>= 8;
            }
            hasherImpl = this;
        }
        return hasherImpl;
    }

    @Override
    public Hasher update(long input) {
        HasherImpl hasherImpl;
        HasherImpl hasherImpl2 = this;
        synchronized (hasherImpl2) {
            long v = input;
            for (int i = 0; i < 8; ++i) {
                this.finalizeWhenCompleted();
                this.chunkState().update((byte)v);
                v >>= 8;
            }
            hasherImpl = this;
        }
        return hasherImpl;
    }

    @Override
    public Hasher update(InputStream input, int len) {
        HasherImpl hasherImpl;
        HasherImpl hasherImpl2 = this;
        synchronized (hasherImpl2) {
            int n;
            byte[] bytes = new byte[package$.MODULE$.CHUNK_LEN()];
            int n2 = this.chunkState().len();
            if (0 == n2 || package$.MODULE$.CHUNK_LEN() == n2) {
                n = package$.MODULE$.CHUNK_LEN();
            } else {
                int len2 = n2;
                n = package$.MODULE$.CHUNK_LEN() - len2;
            }
            int consume = n;
            int read = input.read(bytes, 0, consume);
            for (int remaining = len - read; remaining > 0 && read >= 0; remaining -= read) {
                int len3 = this.finalizeWhenCompleted();
                this.chunkState().update(bytes, 0, read);
                consume = package$.MODULE$.CHUNK_LEN() - len3;
                read = input.read(bytes, 0, consume);
            }
            hasherImpl = this;
        }
        return hasherImpl;
    }

    @Override
    public Hasher update(ByteBuffer input, int len) {
        HasherImpl hasherImpl;
        HasherImpl hasherImpl2 = this;
        synchronized (hasherImpl2) {
            int consume;
            byte[] bytes = new byte[package$.MODULE$.CHUNK_LEN()];
            for (int remaining = len; remaining > 0 && input.hasRemaining(); remaining -= consume) {
                int chunkLen = this.finalizeWhenCompleted();
                consume = Math.min(package$.MODULE$.CHUNK_LEN() - chunkLen, remaining);
                input.get(bytes, 0, consume);
                this.chunkState().update(bytes, 0, consume);
            }
            hasherImpl = this;
        }
        return hasherImpl;
    }

    /*
     * WARNING - void declaration
     */
    private Output getOutput() {
        Output output;
        HasherImpl hasherImpl = this;
        synchronized (hasherImpl) {
            Output output2;
            if (this.cvStackLen() == 0) {
                output2 = this.chunkState().output();
            } else {
                void var3_2;
                Output output3 = this.chunkState().unsafeOutput();
                int[] cv = new int[package$.MODULE$.BLOCK_LEN_WORDS()];
                int[] blockWords = new int[package$.MODULE$.BLOCK_LEN_WORDS()];
                int parentNodesRemaining = this.cvStackLen();
                while (parentNodesRemaining > 0) {
                    output3.chainingValue(cv);
                    output3 = CommonFunction$.MODULE$.parentOutput(blockWords, this.cvStack()[--parentNodesRemaining], cv, this.key(), this.flags());
                }
                output2 = var3_2;
            }
            output = output2;
        }
        return output;
    }

    @Override
    public void done(byte[] out, int offset, int len) {
        this.getOutput().rootBytes(out, offset, len);
    }

    @Override
    public void done(byte[] out) {
        this.done(out, 0, out.length);
    }

    @Override
    public byte done() {
        return this.getOutput().rootByte();
    }

    @Override
    public short doneShort() {
        return this.getOutput().rootShort();
    }

    @Override
    public int doneInt() {
        return this.getOutput().rootInt();
    }

    @Override
    public long doneLong() {
        return this.getOutput().rootLong();
    }

    @Override
    public void done(OutputStream out, int len) {
        this.getOutput().rootBytes(out, len);
    }

    @Override
    public void done(ByteBuffer out, int len) {
        this.getOutput().rootBytes(out, len);
    }

    @Override
    public void doneXor(byte[] in, int inOff, byte[] out, int outOff, int len) {
        this.getOutput().rootBytesXor(in, inOff, out, outOff, len);
    }

    @Override
    public void doneXor(byte[] out) {
        this.doneXor(out, 0, out, 0, out.length);
    }

    @Override
    public void doneXor(InputStream in, OutputStream out, int len) {
        this.getOutput().rootBytesXor(in, out, len);
    }

    @Override
    public void doneXor(ByteBuffer in, ByteBuffer out, int len) {
        this.getOutput().rootBytesXor(in, out, len);
    }
}

