/*
 * Decompiled with CFR 0.152.
 */
package pt.kcry.blake3;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import pt.kcry.blake3.CommonFunction$;
import pt.kcry.blake3.package$;
import scala.Int$;

public class Output {
    private final int[] inputChainingValue;
    private final int[] blockWords;
    private final long counter;
    private final int blockLen;
    private final int flags;

    public Output(int[] inputChainingValue, int[] blockWords, long counter, int blockLen, int flags) {
        this.inputChainingValue = inputChainingValue;
        this.blockWords = blockWords;
        this.counter = counter;
        this.blockLen = blockLen;
        this.flags = flags;
    }

    public int[] inputChainingValue() {
        return this.inputChainingValue;
    }

    public int[] blockWords() {
        return this.blockWords;
    }

    public long counter() {
        return this.counter;
    }

    public int blockLen() {
        return this.blockLen;
    }

    public int flags() {
        return this.flags;
    }

    public void chainingValue(int[] chainingValue) {
        CommonFunction$.MODULE$.compressInPlace(chainingValue, this.inputChainingValue(), this.blockWords(), this.counter(), this.blockLen(), this.flags());
    }

    public void rootBytes(byte[] out, int off, int len) {
        int outputBlockCounter = 0;
        int pos = off;
        int lim = off + len;
        int blockLenWords = package$.MODULE$.BLOCK_LEN_WORDS();
        int[] words = new int[blockLenWords];
        int flags = this.flags() | package$.MODULE$.ROOT();
        while (pos < lim) {
            CommonFunction$.MODULE$.compressInPlace(words, this.inputChainingValue(), this.blockWords(), Int$.MODULE$.int2long(outputBlockCounter), this.blockLen(), flags);
            int wordIdx = 0;
            block6: while (wordIdx < blockLenWords && pos < lim) {
                int word = words[wordIdx];
                ++wordIdx;
                int n = lim - pos;
                switch (n) {
                    case 1: {
                        out[pos] = (byte)word;
                        ++pos;
                        continue block6;
                    }
                    case 2: {
                        out[pos] = (byte)word;
                        out[++pos] = (byte)(word >>> 8);
                        ++pos;
                        continue block6;
                    }
                    case 3: {
                        out[pos] = (byte)word;
                        out[++pos] = (byte)(word >>> 8);
                        out[++pos] = (byte)(word >>> 16);
                        ++pos;
                        continue block6;
                    }
                }
                out[pos] = (byte)word;
                out[++pos] = (byte)(word >>> 8);
                out[++pos] = (byte)(word >>> 16);
                out[++pos] = (byte)(word >>> 24);
                ++pos;
            }
            ++outputBlockCounter;
        }
    }

    public void rootBytesXor(byte[] in, int inOff, byte[] out, int outOff, int len) {
        int outputBlockCounter = 0;
        int inPos = inOff;
        int outPos = outOff;
        int outLim = outOff + len;
        int blockLenWords = package$.MODULE$.BLOCK_LEN_WORDS();
        int[] words = new int[blockLenWords];
        int flags = this.flags() | package$.MODULE$.ROOT();
        while (outPos < outLim) {
            CommonFunction$.MODULE$.compressInPlace(words, this.inputChainingValue(), this.blockWords(), Int$.MODULE$.int2long(outputBlockCounter), this.blockLen(), flags);
            int wordIdx = 0;
            block6: while (wordIdx < blockLenWords && outPos < outLim) {
                int word = words[wordIdx];
                ++wordIdx;
                int n = outLim - outPos;
                switch (n) {
                    case 1: {
                        out[outPos] = (byte)(in[inPos] ^ word);
                        ++inPos;
                        ++outPos;
                        continue block6;
                    }
                    case 2: {
                        out[outPos] = (byte)(in[inPos] ^ word);
                        out[++outPos] = (byte)(in[++inPos] ^ word >>> 8);
                        ++inPos;
                        ++outPos;
                        continue block6;
                    }
                    case 3: {
                        out[outPos] = (byte)(in[inPos] ^ word);
                        out[++outPos] = (byte)(in[++inPos] ^ word >>> 8);
                        out[++outPos] = (byte)(in[++inPos] ^ word >>> 16);
                        ++inPos;
                        ++outPos;
                        continue block6;
                    }
                }
                out[outPos] = (byte)(in[inPos] ^ word);
                out[++outPos] = (byte)(in[++inPos] ^ word >>> 8);
                out[++outPos] = (byte)(in[++inPos] ^ word >>> 16);
                out[++outPos] = (byte)(in[++inPos] ^ word >>> 24);
                ++inPos;
                ++outPos;
            }
            ++outputBlockCounter;
        }
    }

    public byte rootByte() {
        return (byte)CommonFunction$.MODULE$.compressSingle(this.inputChainingValue(), this.blockWords(), 0L, this.blockLen(), this.flags() | package$.MODULE$.ROOT());
    }

    public short rootShort() {
        return (short)CommonFunction$.MODULE$.compressSingle(this.inputChainingValue(), this.blockWords(), 0L, this.blockLen(), this.flags() | package$.MODULE$.ROOT());
    }

    public int rootInt() {
        return CommonFunction$.MODULE$.compressSingle(this.inputChainingValue(), this.blockWords(), 0L, this.blockLen(), this.flags() | package$.MODULE$.ROOT());
    }

    public long rootLong() {
        return CommonFunction$.MODULE$.compressSingleLong(this.inputChainingValue(), this.blockWords(), 0L, this.blockLen(), this.flags() | package$.MODULE$.ROOT());
    }

    public void rootBytes(OutputStream out, int len) {
        int outputBlockCounter = 0;
        int pos = 0;
        int blockLenWords = package$.MODULE$.BLOCK_LEN_WORDS();
        int[] words = new int[blockLenWords];
        int flags = this.flags() | package$.MODULE$.ROOT();
        while (pos < len) {
            CommonFunction$.MODULE$.compressInPlace(words, this.inputChainingValue(), this.blockWords(), Int$.MODULE$.int2long(outputBlockCounter), this.blockLen(), flags);
            int wordIdx = 0;
            block6: while (wordIdx < blockLenWords && pos < len) {
                int word = words[wordIdx];
                ++wordIdx;
                int n = len - pos;
                switch (n) {
                    case 1: {
                        out.write(word);
                        ++pos;
                        continue block6;
                    }
                    case 2: {
                        out.write(word);
                        out.write(word >>> 8);
                        pos += 2;
                        continue block6;
                    }
                    case 3: {
                        out.write(word);
                        out.write(word >>> 8);
                        out.write(word >>> 16);
                        pos += 3;
                        continue block6;
                    }
                }
                out.write(word);
                out.write(word >>> 8);
                out.write(word >>> 16);
                out.write(word >>> 24);
                pos += 4;
            }
            ++outputBlockCounter;
        }
    }

    public void rootBytesXor(InputStream in, OutputStream out, int len) {
        int outputBlockCounter = 0;
        int pos = 0;
        int blockLenWords = package$.MODULE$.BLOCK_LEN_WORDS();
        int[] words = new int[blockLenWords];
        int flags = this.flags() | package$.MODULE$.ROOT();
        while (pos < len) {
            CommonFunction$.MODULE$.compressInPlace(words, this.inputChainingValue(), this.blockWords(), Int$.MODULE$.int2long(outputBlockCounter), this.blockLen(), flags);
            int wordIdx = 0;
            block6: while (wordIdx < blockLenWords && pos < len) {
                int word = words[wordIdx];
                ++wordIdx;
                int n = len - pos;
                switch (n) {
                    case 1: {
                        out.write(in.read() ^ word);
                        ++pos;
                        continue block6;
                    }
                    case 2: {
                        out.write(in.read() ^ word);
                        out.write(in.read() ^ word >>> 8);
                        pos += 2;
                        continue block6;
                    }
                    case 3: {
                        out.write(in.read() ^ word);
                        out.write(in.read() ^ word >>> 8);
                        out.write(in.read() ^ word >>> 16);
                        pos += 3;
                        continue block6;
                    }
                }
                out.write(in.read() ^ word);
                out.write(in.read() ^ word >>> 8);
                out.write(in.read() ^ word >>> 16);
                out.write(in.read() ^ word >>> 24);
                pos += 4;
            }
            ++outputBlockCounter;
        }
    }

    public void rootBytes(ByteBuffer out, int len) {
        int outputBlockCounter = 0;
        int pos = 0;
        int blockLenWords = package$.MODULE$.BLOCK_LEN_WORDS();
        int[] words = new int[blockLenWords];
        int flags = this.flags() | package$.MODULE$.ROOT();
        while (pos < len) {
            CommonFunction$.MODULE$.compressInPlace(words, this.inputChainingValue(), this.blockWords(), Int$.MODULE$.int2long(outputBlockCounter), this.blockLen(), flags);
            int wordIdx = 0;
            block6: while (wordIdx < blockLenWords && pos < len) {
                int word = words[wordIdx];
                ++wordIdx;
                int n = len - pos;
                switch (n) {
                    case 1: {
                        out.put((byte)word);
                        ++pos;
                        continue block6;
                    }
                    case 2: {
                        out.put((byte)word);
                        out.put((byte)(word >>> 8));
                        pos += 2;
                        continue block6;
                    }
                    case 3: {
                        out.put((byte)word);
                        out.put((byte)(word >>> 8));
                        out.put((byte)(word >>> 16));
                        pos += 3;
                        continue block6;
                    }
                }
                out.put((byte)word);
                out.put((byte)(word >>> 8));
                out.put((byte)(word >>> 16));
                out.put((byte)(word >>> 24));
                pos += 4;
            }
            ++outputBlockCounter;
        }
    }

    public void rootBytesXor(ByteBuffer in, ByteBuffer out, int len) {
        int outputBlockCounter = 0;
        int pos = 0;
        int blockLenWords = package$.MODULE$.BLOCK_LEN_WORDS();
        int[] words = new int[blockLenWords];
        int flags = this.flags() | package$.MODULE$.ROOT();
        while (pos < len) {
            CommonFunction$.MODULE$.compressInPlace(words, this.inputChainingValue(), this.blockWords(), Int$.MODULE$.int2long(outputBlockCounter), this.blockLen(), flags);
            int wordIdx = 0;
            block6: while (wordIdx < blockLenWords && pos < len) {
                int word = words[wordIdx];
                ++wordIdx;
                int n = len - pos;
                switch (n) {
                    case 1: {
                        out.put((byte)(in.get() ^ word));
                        ++pos;
                        continue block6;
                    }
                    case 2: {
                        out.put((byte)(in.get() ^ word));
                        out.put((byte)(in.get() ^ word >>> 8));
                        pos += 2;
                        continue block6;
                    }
                    case 3: {
                        out.put((byte)(in.get() ^ word));
                        out.put((byte)(in.get() ^ word >>> 8));
                        out.put((byte)(in.get() ^ word >>> 16));
                        pos += 3;
                        continue block6;
                    }
                }
                out.put((byte)(in.get() ^ word));
                out.put((byte)(in.get() ^ word >>> 8));
                out.put((byte)(in.get() ^ word >>> 16));
                out.put((byte)(in.get() ^ word >>> 24));
                pos += 4;
            }
            ++outputBlockCounter;
        }
    }
}

