/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.util.SafeEncoder;

public class RediSearchUtil {
    private static final Set<Character> ESCAPE_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf(','), Character.valueOf('.'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('='), Character.valueOf('~'), Character.valueOf('|')));

    public static Map<String, String> toStringMap(Map<String, Object> input) {
        return RediSearchUtil.toStringMap(input, false);
    }

    public static Map<String, String> toStringMap(Map<String, Object> input, boolean stringEscape) {
        HashMap<String, String> output = new HashMap<String, String>(input.size());
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            String str;
            String key = entry.getKey();
            Object obj = entry.getValue();
            if (key == null || obj == null) {
                throw new NullPointerException("A null argument cannot be sent to Redis.");
            }
            if (obj instanceof byte[]) {
                str = SafeEncoder.encode((byte[])obj);
            } else if (obj instanceof GeoCoordinate) {
                GeoCoordinate geo = (GeoCoordinate)obj;
                str = geo.getLongitude() + "," + geo.getLatitude();
            } else {
                str = obj instanceof String ? (stringEscape ? RediSearchUtil.escape((String)obj) : (String)obj) : String.valueOf(obj);
            }
            output.put(key, str);
        }
        return output;
    }

    public static byte[] ToByteArray(float[] input) {
        byte[] bytes = new byte[4 * input.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().put(input);
        return bytes;
    }

    public static String escape(String text) {
        return RediSearchUtil.escape(text, false);
    }

    public static String escapeQuery(String query) {
        return RediSearchUtil.escape(query, true);
    }

    public static String escape(String text, boolean querying) {
        char[] chars = text.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char ch : chars) {
            if (ESCAPE_CHARS.contains(Character.valueOf(ch)) || querying && ch == ' ') {
                sb.append("\\");
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String unescape(String text) {
        return text.replace("\\", "");
    }

    private RediSearchUtil() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

