/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import com.google.common.collect.MapMaker;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.LogProxy;

public class ClickHouseDriver
implements Driver {
    private static final Logger logger = LoggerFactory.getLogger(ClickHouseDriver.class);
    private final ConcurrentMap<ClickHouseConnectionImpl, Boolean> connections = new MapMaker().weakKeys().makeMap();
    private final ScheduledExecutorService connectionsCleaner = Executors.newSingleThreadScheduledExecutor();

    @Override
    public ClickHouseConnection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        logger.info("Creating connection");
        ClickHouseConnectionImpl connection = new ClickHouseConnectionImpl(url, info);
        this.registerConnection(connection);
        return LogProxy.wrap(ClickHouseConnection.class, connection);
    }

    public ClickHouseConnection connect(String url, ClickHouseProperties properties) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        logger.info("Creating connection");
        ClickHouseConnectionImpl connection = new ClickHouseConnectionImpl(url, properties);
        this.registerConnection(connection);
        return LogProxy.wrap(ClickHouseConnection.class, connection);
    }

    private synchronized void registerConnection(ClickHouseConnectionImpl connection) {
        this.connections.put(connection, true);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:clickhouse:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void scheduleConnectionsCleaning(int rate, TimeUnit timeUnit) {
        this.connectionsCleaner.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    for (ClickHouseConnectionImpl connection : ClickHouseDriver.this.connections.keySet()) {
                        connection.cleanConnections();
                    }
                }
                catch (Exception e) {
                    logger.error("error evicting connections: " + e);
                }
            }
        }, 0L, rate, timeUnit);
    }

    static {
        ClickHouseDriver driver = new ClickHouseDriver();
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        logger.info("Driver registered");
    }
}

