/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.util.concurrent.TimeUnit;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.IpVersionPriorityResolver;

public class ClickHouseHttpClientBuilder {
    private final ClickHouseProperties properties;

    public ClickHouseHttpClientBuilder(ClickHouseProperties properties) {
        this.properties = properties;
    }

    public CloseableHttpClient buildClient() {
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.getConnectionManager()).setKeepAliveStrategy(this.createKeepAliveStrategy()).setDefaultConnectionConfig(this.getConnectionConfig()).setDefaultRequestConfig(this.getRequestConfig()).disableContentCompression().build();
    }

    private PoolingHttpClientConnectionManager getConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build(), null, null, (DnsResolver)new IpVersionPriorityResolver(), (long)this.properties.getTimeToLiveMillis(), TimeUnit.MILLISECONDS);
        connectionManager.setDefaultMaxPerRoute(this.properties.getDefaultMaxPerRoute());
        connectionManager.setMaxTotal(this.properties.getMaxTotal());
        return connectionManager;
    }

    private ConnectionConfig getConnectionConfig() {
        return ConnectionConfig.custom().setBufferSize(this.properties.getApacheBufferSize()).build();
    }

    private RequestConfig getRequestConfig() {
        return RequestConfig.custom().setSocketTimeout(this.properties.getSocketTimeout()).setConnectTimeout(this.properties.getConnectionTimeout()).build();
    }

    private ConnectionKeepAliveStrategy createKeepAliveStrategy() {
        return new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    return -1L;
                }
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(httpResponse.headerIterator("Connection"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    if (param == null || !param.equalsIgnoreCase("Keep-Alive")) continue;
                    return ClickHouseHttpClientBuilder.this.properties.getKeepAliveTimeout();
                }
                return -1L;
            }
        };
    }
}

