/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import se.natusoft.tools.optionsmgr.OptionsException;
import se.natusoft.tools.optionsmgr.OptionsModelException;
import se.natusoft.tools.optionsmgr.internal.Arguments;
import se.natusoft.tools.optionsmgr.internal.EnumHelper;
import se.natusoft.tools.optionsmgr.internal.MethodFinder;
import se.natusoft.tools.optionsmgr.internal.OMOptions;
import se.natusoft.tools.optionsmgr.internal.OptionInfo;
import se.natusoft.tools.optionsmgr.internal.OptionInfos;
import se.natusoft.tools.optionsmgr.internal.OptionModelInfo;
import se.natusoft.tools.optionsmgr.internal.OptionsAnnotationHelper;
import se.natusoft.tools.optionsmgr.internal.OptionsManagerType;
import se.natusoft.tools.optionsmgr.internal.OptionsModelAnnotationHelper;
import se.natusoft.tools.optionsmgr.internal.Path;
import se.natusoft.tools.optionsmgr.internal.PropertyInfo;
import se.natusoft.tools.optionsmgr.internal.PropertyTypesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionsManager<T> {
    private static final PropertyTypesHelper Supported_Types = PropertyTypesHelper.getInstance();
    private Class<T> optionsModelClass = null;
    private OptionInfos optionInfos = new OptionInfos();
    private OptionModelInfo optionModelInfo = null;
    private OMOptions omOptions = null;
    private static final String FORMAT_WORDS = " \\ | \\ \\ | \\a\\ | \\m\\ ";

    protected OptionsManager(Class optionsModelClass, OptionsManagerType optionsManagerType) throws OptionsModelException {
        this.optionsModelClass = optionsModelClass;
        this.omOptions = new OMOptions();
        this.omOptions.setOptionsManagerType(optionsManagerType);
        this.optionModelInfo = new OptionModelInfo();
        String startPath = optionsModelClass.getSimpleName();
        startPath = startPath.substring(0, 1).toLowerCase() + startPath.substring(1);
        String name = optionsModelClass.getSimpleName();
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        String description = "";
        OptionsModelAnnotationHelper optionsModelAnn = new OptionsModelAnnotationHelper(this.optionsModelClass);
        if (optionsModelAnn.hasNameAnnotation()) {
            name = optionsModelAnn.getName();
            startPath = optionsModelAnn.getName();
        }
        if (optionsModelAnn.hasDescription()) {
            description = optionsModelAnn.getDescription();
        }
        Path publicPath = new Path(startPath);
        Path realPath = new Path(startPath);
        this.optionModelInfo.setOMOptions(this.omOptions);
        this.optionModelInfo.setName(name);
        this.optionModelInfo.setDescription(description);
        this.optionModelInfo.setType(optionsModelClass);
        this.optionModelInfo.setOwner(null);
        this.optionModelInfo.setPublicPath(publicPath);
        this.optionModelInfo.setRealPath(realPath);
        this.optionInfos.addOptionInfo(this.optionModelInfo);
        this.parseModel(optionsModelClass, publicPath, realPath, this.optionModelInfo);
    }

    private final void parseModel(Class optionsModelClass, Path publicPath, Path realPath, OptionModelInfo owner) throws OptionsModelException {
        Method[] methods;
        Field[] fields;
        ArrayList<PropertyInfo> properties = new ArrayList<PropertyInfo>();
        for (Field field : fields = optionsModelClass.getDeclaredFields()) {
            PropertyInfo propInfo = new PropertyInfo(field);
            OptionsAnnotationHelper optionAnn = new OptionsAnnotationHelper(propInfo);
            if (!optionAnn.isOption()) continue;
            propInfo.setAnnotationHelper(optionAnn);
            properties.add(propInfo);
        }
        for (Method method : methods = optionsModelClass.getDeclaredMethods()) {
            PropertyInfo propInfo = new PropertyInfo(method);
            OptionsAnnotationHelper optionAnn = new OptionsAnnotationHelper(propInfo);
            if (!optionAnn.isOption()) continue;
            propInfo.setAnnotationHelper(optionAnn);
            properties.add(propInfo);
        }
        for (PropertyInfo property : properties) {
            String propertyName = property.getName();
            OptionsAnnotationHelper optionAnn = property.getAnnotationHelper();
            if (optionAnn.hasName()) {
                propertyName = optionAnn.getName();
            }
            Class optionType = property.getType();
            if (optionAnn.hasType()) {
                optionType = optionAnn.getType();
            }
            if (property.isLeaf()) {
                String name = property.getName();
                if (optionAnn.hasName()) {
                    name = optionAnn.getName();
                }
                OptionInfo optionInfo = new OptionInfo();
                optionInfo.setOMOptions(this.omOptions);
                optionInfo.setName(name);
                optionInfo.setPropertyInfo(property);
                optionInfo.setType(optionType);
                optionInfo.setRequired(optionAnn.isRequired());
                optionInfo.setDescription(optionAnn.getDescription());
                optionInfo.setPropertyValueValidator(optionAnn.getPropertyValueValidator());
                optionInfo.setPublicPath(new Path(publicPath, name));
                optionInfo.setRealPath(new Path(realPath, name));
                optionInfo.setOwner(owner);
                if (optionAnn.isFlag()) {
                    if (optionInfo.isBooleanType()) {
                        optionInfo.setFlag(true);
                    } else {
                        throw new OptionsModelException("Invalid annotation of 'flag=true' on non boolean JavaBean property! ['" + optionInfo.getPublicPath() + "']");
                    }
                }
                owner.addChild(optionInfo);
                try {
                    String setterMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                    Method setterMethod = MethodFinder.findMethod(optionsModelClass, new MethodFinder.MethodDesc[]{new MethodFinder.MethodDesc(setterMethodName, new Class[]{optionType}), new MethodFinder.MethodDesc(setterMethodName + "s", new Class[]{property.getType()}), new MethodFinder.MethodDesc(setterMethodName, new Class[]{property.getType()})});
                    optionInfo.setSetterMethod(setterMethod);
                    if (Supported_Types.isCollection(setterMethod.getParameterTypes()[0])) {
                        if (this.omOptions.getOptionsManagerType() == OptionsManagerType.RANDOM) {
                            throw new OptionsModelException("A model with Collection bean properties has been found and this is not supported by " + this.getClass().getSimpleName() + "!");
                        }
                        optionInfo.setCollectionType(property.getType());
                    }
                }
                catch (NoSuchMethodException nsme) {
                    throw new OptionsModelException("No setter method for option '" + propertyName + "' in model '" + optionsModelClass.getName() + "'!");
                }
                this.optionInfos.addOptionInfo(optionInfo);
            }
            if (!property.isBranch()) continue;
            OptionsModelAnnotationHelper optionsModelAnn = new OptionsModelAnnotationHelper(property.getType());
            String name = property.getName();
            if (optionAnn.hasName()) {
                name = optionAnn.getName();
            } else if (optionsModelAnn.hasName()) {
                name = optionsModelAnn.getName();
            }
            String description = "";
            if (optionAnn.hasDescription()) {
                description = optionAnn.getDescription();
            } else if (optionsModelAnn.hasDescription()) {
                description = optionsModelAnn.getDescription();
            }
            Path modelPublicPath = new Path(publicPath, name);
            Path modelRealPath = new Path(realPath, property.getName());
            OptionModelInfo optionInfo = new OptionModelInfo();
            optionInfo.setOMOptions(this.omOptions);
            optionInfo.setName(name);
            optionInfo.setDescription(description);
            optionInfo.setPropertyInfo(property);
            optionInfo.setType(optionType);
            optionInfo.setRequired(optionAnn.isRequired());
            optionInfo.setPropertyValueValidator(optionAnn.getPropertyValueValidator());
            optionInfo.setOwner(owner);
            optionInfo.setPublicPath(modelPublicPath);
            optionInfo.setRealPath(modelRealPath);
            owner.addChild(optionInfo);
            Method setter = null;
            try {
                String setterMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                String adderMethodName = "add" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                setter = MethodFinder.findMethod(optionsModelClass, new MethodFinder.MethodDesc[]{new MethodFinder.MethodDesc(setterMethodName, new Class[]{optionType}), new MethodFinder.MethodDesc(setterMethodName + "s", new Class[]{property.getType()}), new MethodFinder.MethodDesc(setterMethodName, new Class[]{property.getType()}), new MethodFinder.MethodDesc(adderMethodName, new Class[]{optionType})});
                optionInfo.setSetterMethod(setter);
                if (Supported_Types.isCollection(setter.getParameterTypes()[0])) {
                    if (this.omOptions.getOptionsManagerType() == OptionsManagerType.RANDOM) {
                        throw new OptionsModelException("A model with Collection bean properties has been found and this is not supported by " + this.getClass().getSimpleName() + "!");
                    }
                    optionInfo.setCollectionType(property.getType());
                }
            }
            catch (NoSuchMethodException nsme) {
                throw new OptionsModelException("No setter method for option sub model '" + propertyName + "' of type '" + optionType.getName() + "' in model '" + optionsModelClass.getName() + "'!");
            }
            this.optionInfos.addOptionInfo(optionInfo);
            this.parseModel(optionType, modelPublicPath, modelRealPath, optionInfo);
        }
        if (!optionsModelClass.getSuperclass().getName().equals("java.lang.Object")) {
            this.parseModel(optionsModelClass.getSuperclass(), publicPath, realPath, owner);
        }
    }

    public void addSimpleDateFormat(String pattern) {
        this.omOptions.addSimpleDateFormat(pattern);
    }

    public void addDateFormat(DateFormat dateFormat) {
        this.omOptions.addDateFormat(dateFormat);
    }

    public void setModelPathSeparator(String publicPathSeparator) {
        this.omOptions.setPublicPathSeparator(publicPathSeparator);
    }

    protected final T loadOptionsNoIO(Arguments arguments) throws OptionsException {
        T result = null;
        try {
            result = this.loadOptions(arguments);
        }
        catch (IOException ioe) {
            throw new RuntimeException("loadOptionsNoIO(Arguments) is a convenience method that takes care of the IOException for those subclasses that never throws an IOException. An IOException has however been received!", ioe);
        }
        return result;
    }

    protected final T loadOptions(Arguments arguments) throws OptionsException, IOException {
        try {
            this.loadOptions(this.optionInfos, arguments);
            this.loadOptions(this.optionModelInfo, arguments);
        }
        catch (OptionsException oe) {
            throw oe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new OptionsException("Loading options failed: " + e.getMessage(), e);
        }
        return (T)this.optionModelInfo.getModelInstance();
    }

    protected void loadOptions(OptionInfos optionInfos, Arguments arguments) throws Exception {
    }

    protected void loadOptions(OptionModelInfo optionModelInfo, Arguments arguments) throws Exception {
    }

    public void validateLoadedOptions() throws OptionsException {
        this.validateLoadedOptions("", ".");
    }

    public void validateLoadedOptions(String optionPrefix, String pathSeparator) throws OptionsException {
        boolean valid = true;
        StringBuilder errors = new StringBuilder();
        for (OptionInfo optionInfo : this.optionInfos.getRequiredOptionInfos()) {
            if (optionInfo.hasReceivedValue()) continue;
            errors.append("'");
            errors.append(optionPrefix);
            errors.append(optionInfo.getName().replaceAll("\\.", pathSeparator));
            errors.append("' is required, but was not provided!\n");
            valid = false;
        }
        if (!valid) {
            throw new OptionsException(errors.toString());
        }
    }

    private boolean isFormatWord(String word) {
        return FORMAT_WORDS.indexOf(word) >= 0;
    }

    private String formatText(String text, String indent, int width) {
        StringBuilder formatted = new StringBuilder();
        StringBuilder line = new StringBuilder();
        line.append(indent);
        boolean autoLineBreak = true;
        int nlCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(text, " ");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (this.isFormatWord(word)) {
                if (word.equals(" \\a\\ ".trim())) {
                    autoLineBreak = true;
                }
                if (word.equals(" \\m\\ ".trim())) {
                    autoLineBreak = false;
                }
            } else {
                line.append(word);
                line.append(" ");
            }
            nlCount = line.length() >= width && autoLineBreak || word.equals(" \\ ".trim()) ? ++nlCount : 0;
            if (nlCount > 2 || (line.length() < width || !autoLineBreak) && !word.equals(" \\ ".trim())) continue;
            formatted.append((CharSequence)line);
            formatted.append("\n");
            line = new StringBuilder();
            line.append(indent);
        }
        if (line.length() > 0) {
            formatted.append((CharSequence)line);
        }
        return formatted.toString();
    }

    public void printHelpText(String optionPrefix, String pathSeparator, PrintStream ps) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(ps));
        this.printHelpText(optionPrefix, pathSeparator, pw);
        pw.flush();
    }

    public void printHelpText(String optionPrefix, String pathSeparator, PrintWriter pw) {
        this.printHelpText(optionPrefix, pathSeparator, pw, this.optionInfos.getAllLeafOptionInfos());
    }

    public void printHelpTextFull(String optionPrefix, String pathSeparator, PrintStream ps) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(ps));
        this.printHelpTextFull(optionPrefix, pathSeparator, pw);
        pw.flush();
    }

    public void printHelpTextFull(String optionPrefix, String pathSeparator, PrintWriter pw) {
        this.printHelpText(optionPrefix, pathSeparator, pw, this.optionInfos.getAllOptionInfos());
    }

    private void printHelpText(String optionPrefix, String pathSeparator, PrintWriter pw, List<OptionInfo> optionInfos) {
        OptionInfo topLevelModelOI = this.optionInfos.getAllOptionInfos().get(0);
        if (topLevelModelOI.getDescription().trim().length() > 0) {
            pw.println(this.formatText(topLevelModelOI.getDescription(), "", 64));
            pw.println();
        }
        for (OptionInfo optionInfo : optionInfos) {
            boolean display = true;
            if (optionInfo instanceof OptionModelInfo && optionInfo.getOwner() == null) {
                display = false;
            }
            if (!display) continue;
            pw.print(optionPrefix);
            pw.print(optionInfo.getPublicPath().getPathAsStringSeparatedBy(pathSeparator));
            if (optionInfo.isLeaf() && !optionInfo.isFlag()) {
                pw.print(" " + Supported_Types.getSupportedType(optionInfo.getType()).getValueTypeRepresentation());
            }
            if (optionInfo.isRequired()) {
                pw.print(" (Required)");
            }
            if (optionInfo.isCollectionType()) {
                if (Supported_Types.isCollection(optionInfo.getSetterMethod().getParameterTypes()[0])) {
                    String path = optionInfo.getPublicPath().getPathAsStringSeparatedBy(pathSeparator);
                    path = path + pathSeparator + optionInfo.getName().substring(0, optionInfo.getName().length() - 1);
                    pw.print(" (Takes multiple " + path + " items)");
                } else {
                    pw.print(" (This can occur multiple times!)");
                }
            }
            if (!optionInfo.isLeaf()) {
                pw.print(" (section)");
            }
            if (optionInfo.getPropertyValueValidator().hasValidation()) {
                pw.println();
                pw.println(this.formatText(optionInfo.getPropertyValueValidator().getMustMatchText() + ".", "    ", 60));
            } else if (Supported_Types.isEnum(optionInfo.getType())) {
                EnumHelper enumHelper = Supported_Types.getEnumHelper(optionInfo.getType());
                pw.println();
                pw.println(this.formatText("Valid values are: " + enumHelper.getAvailableEnumsAsQuotedList() + ".", "    ", 60));
            }
            pw.println();
            pw.println(this.formatText(optionInfo.getDescription(), "    ", 60));
            pw.println();
        }
    }

    public String getHelpTextAsString(String optionPrefix, String pathSeparator) throws OptionsException {
        String helpText = "";
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.printHelpText(optionPrefix, pathSeparator, pw);
            helpText = sw.toString();
            pw.close();
            sw.close();
        }
        catch (IOException ioe) {
            throw new OptionsException("Failed to produce help text!", ioe);
        }
        return helpText;
    }

    public String getFullHelpTextAsString(String optionPrefix, String pathSeparator) throws OptionsException {
        String helpText = "";
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.printHelpTextFull(optionPrefix, pathSeparator, pw);
            helpText = sw.toString();
            pw.close();
            sw.close();
        }
        catch (IOException ioe) {
            throw new OptionsException("Failed to produce help text!", ioe);
        }
        return helpText;
    }
}

