/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import se.natusoft.tools.optionsmgr.OptionsException;
import se.natusoft.tools.optionsmgr.OptionsManager;
import se.natusoft.tools.optionsmgr.OptionsModelException;
import se.natusoft.tools.optionsmgr.internal.Arguments;
import se.natusoft.tools.optionsmgr.internal.OptionInfo;
import se.natusoft.tools.optionsmgr.internal.OptionInfos;
import se.natusoft.tools.optionsmgr.internal.OptionsManagerType;
import se.natusoft.tools.optionsmgr.internal.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesOptionsManager<T>
extends OptionsManager<T> {
    public PropertiesOptionsManager(Class modelClass) throws OptionsModelException {
        super(modelClass, OptionsManagerType.RANDOM);
        this.setModelPathSeparator(".");
    }

    public T loadOptions(File propertiesFile) throws OptionsException, IOException {
        POMArguments arguments = new POMArguments();
        try {
            arguments.propertiesStream = new FileInputStream(propertiesFile);
        }
        catch (IOException ioe) {
            throw new OptionsException("Failed to open properties file!", ioe);
        }
        return this.loadOptions(arguments);
    }

    public T loadOptions(InputStream propertiesStream) throws OptionsException, IOException {
        POMArguments arguments = new POMArguments();
        arguments.propertiesStream = propertiesStream;
        return this.loadOptions(arguments);
    }

    public T loadOptions(File propertiesFile, boolean xmlFormat) throws OptionsException, IOException {
        POMArguments arguments = new POMArguments();
        arguments.xmlFormat = xmlFormat;
        try {
            arguments.propertiesStream = new FileInputStream(propertiesFile);
        }
        catch (IOException ioe) {
            throw new OptionsException("Failed to open properties file!", ioe);
        }
        return this.loadOptions(arguments);
    }

    public T loadOptions(InputStream propertiesStream, boolean xmlFormat) throws OptionsException, IOException {
        POMArguments arguments = new POMArguments();
        arguments.xmlFormat = xmlFormat;
        arguments.propertiesStream = propertiesStream;
        return this.loadOptions(arguments);
    }

    public T loadOptions(Properties properties) throws OptionsException, IOException {
        POMArguments arguments = new POMArguments();
        arguments.properties = properties;
        return this.loadOptions(arguments);
    }

    @Override
    protected void loadOptions(OptionInfos optionInfos, Arguments arguments) throws Exception {
        POMArguments loadArguments = (POMArguments)arguments;
        Properties props = loadArguments.properties;
        if (props == null) {
            props = new Properties();
            if (loadArguments.xmlFormat) {
                props.loadFromXML(loadArguments.propertiesStream);
            } else {
                props.load(loadArguments.propertiesStream);
            }
            loadArguments.propertiesStream.close();
        }
        for (String propKey : props.stringPropertyNames()) {
            String propValue = props.getProperty(propKey);
            OptionInfo optionInfo = optionInfos.getOptionInfoByPublicPath(new Path(propKey));
            if (optionInfo == null) {
                throw new OptionsException("'" + propKey + "' is not a known option!");
            }
            optionInfo.assureModelInstance();
            optionInfo.setValueAsString(propValue);
        }
    }

    private static class POMArguments
    implements Arguments {
        private InputStream propertiesStream = null;
        private boolean xmlFormat = false;
        private Properties properties = null;

        private POMArguments() {
        }
    }
}

