/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import se.natusoft.tools.optionsmgr.OptionsException;
import se.natusoft.tools.optionsmgr.OptionsManager;
import se.natusoft.tools.optionsmgr.OptionsModelException;
import se.natusoft.tools.optionsmgr.internal.Arguments;
import se.natusoft.tools.optionsmgr.internal.OptionInfo;
import se.natusoft.tools.optionsmgr.internal.OptionInfos;
import se.natusoft.tools.optionsmgr.internal.OptionModelInfo;
import se.natusoft.tools.optionsmgr.internal.OptionsManagerType;
import se.natusoft.tools.optionsmgr.internal.Path;
import se.natusoft.tools.optionsmgr.internal.utils.XMLAttribute;
import se.natusoft.tools.optionsmgr.internal.utils.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLAttributeOptionsManager<T>
extends OptionsManager<T> {
    public XMLAttributeOptionsManager(Class modelClass) throws OptionsModelException {
        super(modelClass, OptionsManagerType.SEQUENTIAL);
        this.setModelPathSeparator("/");
    }

    public T loadOptions(File xmlFile) throws OptionsException, IOException {
        XMLAOMArguments arguments = new XMLAOMArguments();
        try {
            arguments.xmlStream = new FileInputStream(xmlFile);
            arguments.closeStream = true;
        }
        catch (IOException ioe) {
            throw new OptionsException("Failed to open XML file!", ioe);
        }
        return this.loadOptions(arguments);
    }

    public T loadOptions(InputStream xmlStream) throws OptionsException, IOException {
        XMLAOMArguments arguments = new XMLAOMArguments();
        arguments.xmlStream = xmlStream;
        return this.loadOptions(arguments);
    }

    @Override
    protected void loadOptions(OptionInfos optionInfos, Arguments arguments) throws Exception {
        Path path;
        OptionInfo optInfo;
        XMLAOMArguments loadArguments = (XMLAOMArguments)arguments;
        Element element = this.parse(loadArguments.xmlStream);
        if (loadArguments.closeStream) {
            loadArguments.xmlStream.close();
        }
        if ((optInfo = optionInfos.getOptionInfoByPublicPath(path = new Path(element.getTagName()))) == null || !(optInfo instanceof OptionModelInfo)) {
            OptionInfo root = optionInfos.getAllOptionInfos().get(0);
            throw new OptionsException("Root element ('" + path + "') is invalid! Expected: '" + root.getPublicPath() + "'!");
        }
        OptionModelInfo modelInfo = (OptionModelInfo)optInfo;
        this.loadOptions(new XMLElement(element), path, modelInfo);
    }

    private void loadOptions(XMLElement element, Path path, OptionModelInfo modelInfo) throws Exception {
        OptionInfo optionInfo;
        modelInfo.instantiateModelAndAddToParent();
        for (XMLAttribute attr : element.getAttributes()) {
            optionInfo = modelInfo.getChildByName(attr.getName());
            if (optionInfo == null) {
                throw new OptionsException("The XML path '" + path.getPathAsStringSeparatedBy("/") + "/" + attr.getName() + "' is invalid! No matching entry in model!");
            }
            optionInfo.setValueAsString(attr.getValue());
        }
        for (XMLElement child : element.getChildElements()) {
            optionInfo = modelInfo.getChildByName(child.getName());
            if (optionInfo == null) {
                throw new OptionsException("The XML path '" + path.getPathAsStringSeparatedBy("/") + "/" + child.getName() + "' is invalid! No matching entry in model!");
            }
            if (!(optionInfo instanceof OptionModelInfo)) {
                throw new OptionsException("The XML path '" + path.getPathAsStringSeparatedBy("/") + "/" + element.getName() + "' is invalid! Expected one of: " + modelInfo.getModelChildNamesAsCommaSeparatedString() + "!");
            }
            OptionModelInfo modInfo = (OptionModelInfo)optionInfo;
            this.loadOptions(child, new Path(path, child.getName()), modInfo);
        }
    }

    private Element parse(InputStream parseStream) throws OptionsException {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            document = docBuilder.parse(parseStream);
        }
        catch (ParserConfigurationException pce) {
            throw new OptionsException("XML parser configuration problems: " + pce.getMessage(), pce);
        }
        catch (SAXException se) {
            throw new OptionsException("XML parser failure: " + se.getMessage(), se);
        }
        catch (IOException ioe) {
            throw new OptionsException("Failed reading XML stream!", ioe);
        }
        return document.getDocumentElement();
    }

    private static class XMLAOMArguments
    implements Arguments {
        private InputStream xmlStream = null;
        private boolean closeStream = false;

        private XMLAOMArguments() {
        }
    }
}

