/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumHelper {
    private Class enumType;

    EnumHelper(Class<? extends Enum> enumType) {
        this.enumType = enumType;
    }

    static boolean isEnum(Class type) {
        return type.isEnum();
    }

    public Enum getEnumForValue(String value) {
        T[] enums;
        Enum enm = null;
        for (Object enumObj : enums = this.enumType.getEnumConstants()) {
            if (!enumObj.toString().toLowerCase().equals(value.toLowerCase())) continue;
            enm = (Enum)enumObj;
        }
        return enm;
    }

    public String[] getEnumNames() {
        T[] enums = this.enumType.getEnumConstants();
        String[] names = new String[enums.length];
        for (int i = 0; i < enums.length; ++i) {
            names[i] = enums[i].toString().toLowerCase();
        }
        return names;
    }

    public String getAvailableEnumsAsQuotedList() {
        T[] enums = this.enumType.getEnumConstants();
        StringBuilder sb = new StringBuilder();
        String comma = "";
        for (Object enm : enums) {
            sb.append(comma);
            sb.append('\"');
            sb.append(enm.toString().toLowerCase());
            sb.append('\"');
            comma = ", ";
        }
        return sb.toString();
    }
}

