/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

import java.lang.reflect.Method;

public class MethodFinder {
    private MethodFinder() {
    }

    public static Method findMethod(Class searchClass, MethodDesc[] methodsToFind) throws NoSuchMethodException {
        Method found = null;
        for (MethodDesc methodDesc : methodsToFind) {
            try {
                found = searchClass.getMethod(methodDesc.getName(), methodDesc.getArgTypes());
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            if (found != null) break;
        }
        if (found == null) {
            throw new NoSuchMethodException("None of the tested methods were found!");
        }
        return found;
    }

    public static class MethodDesc {
        private String name;
        private Class[] argTypes;

        public MethodDesc(String name, Class[] argTypes) {
            this.name = name;
            this.argTypes = argTypes;
        }

        public String getName() {
            return this.name;
        }

        public Class[] getArgTypes() {
            return this.argTypes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("name='" + this.name + "', argTypes=[");
            for (Class argClass : this.argTypes) {
                sb.append(argClass.getName());
                sb.append(" ");
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

