/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import se.natusoft.tools.optionsmgr.internal.OptionsManagerType;

public class OMOptions {
    private List<DateFormat> dateFormats = new ArrayList<DateFormat>();
    private OptionsManagerType optionsManagerType;
    private String publicPathSeparator = ".";

    public OMOptions() {
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm"));
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd"));
        this.dateFormats.add(new SimpleDateFormat("HH:mm"));
    }

    public void addSimpleDateFormat(String pattern) {
        this.dateFormats.add(new SimpleDateFormat(pattern));
    }

    public void addDateFormat(DateFormat dateFormat) {
        this.dateFormats.add(dateFormat);
    }

    public Date toDate(String dateValue) {
        Date date = null;
        for (DateFormat dateFormat : this.dateFormats) {
            try {
                date = dateFormat.parse(dateValue);
                if (date == null) continue;
                break;
            }
            catch (ParseException pe) {
            }
        }
        return date;
    }

    public OptionsManagerType getOptionsManagerType() {
        return this.optionsManagerType;
    }

    public void setOptionsManagerType(OptionsManagerType optionsManagerType) {
        this.optionsManagerType = optionsManagerType;
    }

    public String getPublicPathSeparator() {
        return this.publicPathSeparator;
    }

    public void setPublicPathSeparator(String pathSeparator) {
        this.publicPathSeparator = pathSeparator;
    }
}

