/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import se.natusoft.tools.optionsmgr.OptionsException;
import se.natusoft.tools.optionsmgr.OptionsModelException;
import se.natusoft.tools.optionsmgr.internal.OMBugException;
import se.natusoft.tools.optionsmgr.internal.OMOptions;
import se.natusoft.tools.optionsmgr.internal.OptionModelInfo;
import se.natusoft.tools.optionsmgr.internal.Path;
import se.natusoft.tools.optionsmgr.internal.PropertyInfo;
import se.natusoft.tools.optionsmgr.internal.PropertyTypesHelper;
import se.natusoft.tools.optionsmgr.internal.PropertyValueValidator;

public class OptionInfo {
    private static final PropertyTypesHelper Supported_Types = PropertyTypesHelper.getInstance();
    private String name = null;
    private Class type = null;
    private boolean required = false;
    private boolean receivedValue = false;
    private String description = null;
    private PropertyValueValidator propertyValueValidator = null;
    private Class collectionType = null;
    private boolean flag = false;
    private Path publicPath = null;
    private Path realPath = null;
    private PropertyInfo propertyInfo = null;
    private Method setterMethod = null;
    private OptionModelInfo owner;
    private OMOptions omOptions = null;
    private Collection currentCollection = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isBooleanType() {
        return Supported_Types.getSupportedType(Boolean.TYPE).isOfType(this.type);
    }

    public void setType(Class type) {
        this.type = type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean hasReceivedValue() {
        return this.receivedValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public boolean isCollectionType() {
        return this.collectionType != null;
    }

    public Class getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class collectionType) {
        this.collectionType = collectionType;
    }

    public boolean isLeaf() {
        return true;
    }

    public Collection createCollectionInstance() throws OptionsModelException {
        Collection collectionInstance;
        try {
            collectionInstance = (Collection)this.getCollectionType().newInstance();
        }
        catch (InstantiationException ie) {
            throw new OptionsModelException("Failed to instantiate " + this.getCollectionType() + " with default constructor!", ie);
        }
        catch (IllegalAccessException ia) {
            throw new OptionsModelException("Not allowed to instantiate " + this.getCollectionType() + " with default constructor!", ia);
        }
        return collectionInstance;
    }

    protected void clearCurrentCollection() {
        this.currentCollection = null;
    }

    public Path getPublicPath() {
        return this.publicPath;
    }

    public String getErrMsgPath() {
        return this.getPublicPath().getPathAsStringSeparatedBy(this.getOMOptions().getPublicPathSeparator());
    }

    public void setPublicPath(Path publicPath) {
        this.publicPath = publicPath;
    }

    public Path getRealPath() {
        return this.realPath;
    }

    public void setRealPath(Path realPath) {
        this.realPath = realPath;
    }

    public OptionModelInfo getOwner() {
        return this.owner;
    }

    public void setOwner(OptionModelInfo owner) {
        this.owner = owner;
    }

    public PropertyInfo getPropertyInfo() {
        return this.propertyInfo;
    }

    public void setPropertyInfo(PropertyInfo propertyInfo) {
        this.propertyInfo = propertyInfo;
    }

    public Method getSetterMethod() {
        return this.setterMethod;
    }

    public void setSetterMethod(Method setterMethod) {
        this.setterMethod = setterMethod;
    }

    public OMOptions getOMOptions() {
        return this.omOptions;
    }

    public void setOMOptions(OMOptions omOptions) {
        this.omOptions = omOptions;
    }

    public void setPropertyValueValidator(PropertyValueValidator propertyValueValidator) {
        this.propertyValueValidator = propertyValueValidator;
    }

    public PropertyValueValidator getPropertyValueValidator() {
        return this.propertyValueValidator;
    }

    public void assureModelInstance() throws OptionsException {
        if (this.getOwner() != null && this.getOwner().getModelInstance() == null) {
            this.getOwner().assureModelInstance();
        }
    }

    void setValue(Object value) throws OptionsException {
        if (this.isBooleanType() && value == null) {
            if (this.flag) {
                value = new Boolean(true);
            } else {
                throw new OptionsException("Invalid null value for boolean! ['" + this.getErrMsgPath() + "']");
            }
        }
        if (this.propertyValueValidator.hasValidation() && !this.propertyValueValidator.isValid(value.toString())) {
            throw new OptionsException("Invalid value (" + value + ") for '" + this.getErrMsgPath() + "'! " + this.propertyValueValidator.getMustMatchText() + "!");
        }
        if (this.owner.getModelInstance() == null) {
            throw new OMBugException("setValue(value) called without a model instace available! use instantiateModel() or assureModelInstance() before calling this!");
        }
        this.receivedValue = true;
        boolean doSetValue = true;
        if (this.isCollectionType()) {
            if (this.currentCollection == null) {
                this.currentCollection = this.createCollectionInstance();
                this.currentCollection.add(value);
                value = this.currentCollection;
            } else {
                this.currentCollection.add(value);
                doSetValue = false;
            }
        }
        if (doSetValue) {
            try {
                if (this.setterMethod == null) {
                    throw new OMBugException("No setter method for '" + this.getErrMsgPath() + "'!");
                }
                this.setterMethod.invoke(this.owner.getModelInstance(), value);
            }
            catch (IllegalAccessException iae) {
                throw new OptionsModelException("Setter (" + this.setterMethod + ") for '" + this.getErrMsgPath() + "' is not accesible!", iae);
            }
            catch (InvocationTargetException ite) {
                throw new OptionsModelException("Failed setting config value (" + value + ") for '" + this.getErrMsgPath() + "': " + ite.getCause().getMessage(), ite.getCause());
            }
        }
    }

    public void setValueAsString(String value) throws OptionsException {
        if (this.owner.getModelInstance() == null) {
            throw new OMBugException("setStringValue(value) called without a model instace available! use instantiateModel() or assureModelInstance() before calling this!");
        }
        if (value == null && !this.flag) {
            throw new OptionsException("Tried to set bad null value for '" + this.getPublicPath() + "'!");
        }
        Object realValue = null;
        try {
            realValue = Supported_Types.convertStringToTypeInstance(this.type, value, this.omOptions);
        }
        catch (OptionsException oe) {
            throw new OptionsException("Error for '" + this.getErrMsgPath() + "': " + oe.getMessage());
        }
        if (Supported_Types.getSupportedType(Boolean.TYPE).isOfType(this.type) && this.isFlag()) {
            realValue = new Boolean(true);
        }
        this.setValue(realValue);
    }

    protected void toString(StringBuilder sb) {
        sb.append("    ");
        sb.append("name=" + this.name);
        sb.append("\n    ");
        sb.append("type=" + this.type);
        sb.append("\n    ");
        sb.append("description=" + this.description);
        sb.append("\n    ");
        sb.append("publicPath=" + this.publicPath);
        sb.append("\n    ");
        sb.append("realPath=" + this.realPath);
        sb.append("\n    ");
        sb.append("flag=" + this.flag);
        sb.append("\n    ");
        sb.append("propertyInfo=" + this.propertyInfo);
        sb.append("\n    ");
        sb.append("setterMethod=" + this.setterMethod);
        sb.append("\n    ");
        sb.append("owner=" + this.owner);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OptionInfo {\n");
        this.toString(sb);
        sb.append("}");
        return sb.toString();
    }
}

