/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

import java.util.ArrayList;
import java.util.List;
import se.natusoft.tools.optionsmgr.internal.OptionInfo;
import se.natusoft.tools.optionsmgr.internal.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionInfos {
    private List<OptionInfo> optionEntries = new ArrayList<OptionInfo>();

    public void addOptionInfo(OptionInfo optionInfo) {
        this.optionEntries.add(optionInfo);
    }

    public OptionInfo getOptionInfoByName(String name) {
        OptionInfo found = null;
        for (OptionInfo optionInfo : this.optionEntries) {
            if (!optionInfo.getName().equals(name)) continue;
            found = optionInfo;
            break;
        }
        return found;
    }

    public OptionInfo getOptionInfoByPublicPath(Path publicPath) {
        OptionInfo found = null;
        for (OptionInfo optionInfo : this.optionEntries) {
            if (!optionInfo.getPublicPath().equals(publicPath)) continue;
            found = optionInfo;
            break;
        }
        return found;
    }

    public OptionInfo getOptionInfoByRealPath(Path realPath) {
        OptionInfo found = null;
        for (OptionInfo optionInfo : this.optionEntries) {
            if (!optionInfo.getRealPath().equals(realPath)) continue;
            found = optionInfo;
            break;
        }
        return found;
    }

    public List<OptionInfo> getRequiredOptionInfos() {
        ArrayList<OptionInfo> requiredOIs = new ArrayList<OptionInfo>();
        for (OptionInfo optionInfo : this.optionEntries) {
            if (!optionInfo.isRequired()) continue;
            requiredOIs.add(optionInfo);
        }
        return requiredOIs;
    }

    public List<OptionInfo> getAllLeafOptionInfos() {
        ArrayList<OptionInfo> valueOIs = new ArrayList<OptionInfo>();
        for (OptionInfo optionInfo : this.optionEntries) {
            if (!optionInfo.isLeaf()) continue;
            valueOIs.add(optionInfo);
        }
        return valueOIs;
    }

    public List<OptionInfo> getAllOptionInfos() {
        return this.optionEntries;
    }
}

