/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

import java.util.ArrayList;
import java.util.List;
import se.natusoft.tools.optionsmgr.OptionsException;
import se.natusoft.tools.optionsmgr.OptionsModelException;
import se.natusoft.tools.optionsmgr.internal.OptionInfo;
import se.natusoft.tools.optionsmgr.internal.OptionsManagerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionModelInfo
extends OptionInfo {
    private Object modelInstance = null;
    private List<OptionInfo> children = new ArrayList<OptionInfo>();

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void addChild(OptionInfo optionInfo) {
        this.children.add(optionInfo);
    }

    public List<OptionInfo> getChildren() {
        return this.children;
    }

    public OptionInfo getChildByName(String name) {
        OptionInfo found = null;
        for (OptionInfo optionInfo : this.children) {
            if (!optionInfo.getName().equals(name)) continue;
            found = optionInfo;
            break;
        }
        return found;
    }

    public String getModelChildNamesAsCommaSeparatedString() {
        StringBuilder sb = new StringBuilder();
        String comma = "";
        for (OptionInfo optionInfo : this.children) {
            if (!(optionInfo instanceof OptionModelInfo)) continue;
            sb.append(comma);
            sb.append(optionInfo.getName());
            comma = ", ";
        }
        return sb.toString();
    }

    public Object getModelInstance() {
        return this.modelInstance;
    }

    public Object instantiateModelAndAddToParent() throws OptionsException {
        OptionModelInfo owner = this.getOwner();
        if (owner != null && this.getOMOptions().getOptionsManagerType() == OptionsManagerType.RANDOM) {
            owner.instantiateModelAndAddToParent();
        }
        if (this.modelInstance == null || this.getOMOptions().getOptionsManagerType() == OptionsManagerType.SEQUENTIAL) {
            try {
                this.modelInstance = this.getType().newInstance();
                if (owner != null) {
                    this.setValue(this.modelInstance);
                }
                this.clearChildCurrentCollections();
            }
            catch (InstantiationException ie) {
                throw new OptionsModelException("Failed to instantiate options model!", ie);
            }
            catch (IllegalAccessException iae) {
                throw new OptionsModelException("Not allowd to instantiate options model!", iae);
            }
        }
        return this.modelInstance;
    }

    private void clearChildCurrentCollections() {
        for (OptionInfo optionInfo : this.children) {
            optionInfo.clearCurrentCollection();
        }
    }

    @Override
    public void assureModelInstance() throws OptionsException {
        if (this.modelInstance == null) {
            this.instantiateModelAndAddToParent();
            if (this.getOwner() != null) {
                this.getOwner().assureModelInstance();
                this.setValue(this.modelInstance);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OptionModelInfo {\n");
        sb.append("    children=" + this.children.size());
        sb.append("\n");
        this.toString(sb);
        sb.append("}");
        return sb.toString();
    }
}

