/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

import se.natusoft.tools.optionsmgr.annotations.Description;
import se.natusoft.tools.optionsmgr.annotations.Flag;
import se.natusoft.tools.optionsmgr.annotations.Name;
import se.natusoft.tools.optionsmgr.annotations.Option;
import se.natusoft.tools.optionsmgr.annotations.Required;
import se.natusoft.tools.optionsmgr.annotations.Type;
import se.natusoft.tools.optionsmgr.annotations.ValidValues;
import se.natusoft.tools.optionsmgr.annotations.Validate;
import se.natusoft.tools.optionsmgr.internal.PropertyInfo;
import se.natusoft.tools.optionsmgr.internal.PropertyValueValidator;

public class OptionsAnnotationHelper {
    private boolean option = false;
    private String description = null;
    private String name = null;
    private Class type = null;
    private boolean required = false;
    PropertyValueValidator pvv = new PropertyValueValidator();
    private boolean flag = false;

    public OptionsAnnotationHelper(PropertyInfo annotatedProp) {
        Flag flagAnn;
        ValidValues validValuesAnn;
        Validate validateAnn;
        Required requiredAnn;
        Type typeAnn;
        Name nameAnn;
        Description descriptionAnn;
        Option optionAnn = annotatedProp.getAnnotation(Option.class);
        if (optionAnn != null) {
            this.option = true;
            this.description = optionAnn.description();
            this.name = optionAnn.name();
            this.type = optionAnn.type();
            this.required = optionAnn.required();
            if (optionAnn.validate().trim().length() > 0) {
                this.pvv = new PropertyValueValidator(optionAnn.validate());
            } else if (optionAnn.validValues().length > 0) {
                this.pvv = new PropertyValueValidator(optionAnn.validValues());
            }
            this.flag = optionAnn.flag();
        }
        if ((descriptionAnn = annotatedProp.getAnnotation(Description.class)) != null) {
            this.description = descriptionAnn.value();
        }
        if ((nameAnn = annotatedProp.getAnnotation(Name.class)) != null) {
            this.name = nameAnn.value();
        }
        if ((typeAnn = annotatedProp.getAnnotation(Type.class)) != null) {
            this.type = typeAnn.value();
        }
        if ((requiredAnn = annotatedProp.getAnnotation(Required.class)) != null) {
            this.required = requiredAnn.value();
        }
        if ((validateAnn = annotatedProp.getAnnotation(Validate.class)) != null) {
            this.pvv = new PropertyValueValidator(validateAnn.value());
        }
        if ((validValuesAnn = annotatedProp.getAnnotation(ValidValues.class)) != null) {
            this.pvv = new PropertyValueValidator(validValuesAnn.value());
        }
        if ((flagAnn = annotatedProp.getAnnotation(Flag.class)) != null) {
            this.flag = flagAnn.value();
        }
    }

    public boolean isOption() {
        return this.option;
    }

    public boolean hasName() {
        return this.name != null && this.name.trim().length() > 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasDescription() {
        return this.description != null && this.description.trim().length() > 0;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasType() {
        return this.type != null && !this.type.equals(Option.class);
    }

    public Class getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public PropertyValueValidator getPropertyValueValidator() {
        return this.pvv;
    }

    public boolean isFlag() {
        return this.flag;
    }
}

