/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

import se.natusoft.tools.optionsmgr.annotations.Description;
import se.natusoft.tools.optionsmgr.annotations.Name;
import se.natusoft.tools.optionsmgr.annotations.OptionsModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsModelAnnotationHelper {
    private String name = "";
    private String description = "";
    private boolean hasNameAnnotation = false;
    private boolean hasDescriptionAnnotation = false;

    public OptionsModelAnnotationHelper(Class<?> modelClass) {
        Name nameAnn;
        Description descriptionAnn;
        OptionsModel optionsModelAnn = modelClass.getAnnotation(OptionsModel.class);
        if (optionsModelAnn != null) {
            this.name = optionsModelAnn.name();
            this.hasNameAnnotation = true;
            if (optionsModelAnn.description().length() > 0) {
                this.description = optionsModelAnn.description();
                this.hasDescriptionAnnotation = true;
            }
        }
        if ((descriptionAnn = modelClass.getAnnotation(Description.class)) != null) {
            this.description = descriptionAnn.value();
            this.hasDescriptionAnnotation = true;
        }
        if ((nameAnn = modelClass.getAnnotation(Name.class)) != null) {
            this.name = nameAnn.value();
            this.hasNameAnnotation = true;
        }
    }

    public boolean hasName() {
        return this.name != null && this.name.trim().length() > 0;
    }

    public boolean hasNameAnnotation() {
        return this.hasNameAnnotation;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasDescription() {
        return this.description != null && this.description.trim().length() > 0;
    }

    public boolean hasDescriptionAnnotation() {
        return this.hasDescriptionAnnotation;
    }

    public String getDescription() {
        return this.description;
    }
}

