/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

public class Path {
    public static final String PATH_SEPARATOR = ".";
    private String path;

    public Path() {
        this.path = "";
    }

    public Path(Path path) {
        this.path = path.path;
    }

    public Path(String path) {
        this.path = path;
    }

    public Path(String rootpath, String name) {
        this.path = rootpath.trim().length() == 0 ? name : rootpath + PATH_SEPARATOR + name;
    }

    public Path(Path rootpath, String name) {
        this.path = rootpath.isEmpty() ? name : rootpath.path + PATH_SEPARATOR + name;
    }

    public static Path fromStringSeparatedBy(String toPath, String pathSeparator) {
        return new Path(toPath.replaceAll("\\" + pathSeparator, PATH_SEPARATOR));
    }

    public boolean isEmpty() {
        return this.path.trim().length() == 0;
    }

    public String getPathAsString() {
        return this.path;
    }

    public String getPathAsStringSeparatedBy(String separator) {
        return this.path.replaceAll("\\.", separator);
    }

    public Path getParentPath() {
        int ix = this.path.lastIndexOf(PATH_SEPARATOR);
        String newPath = this.path;
        if (ix > 0) {
            newPath = newPath.substring(0, ix);
        }
        return new Path(newPath);
    }

    public boolean equals(Object compareTo) {
        if (compareTo instanceof String) {
            return this.path.equals(compareTo);
        }
        if (compareTo instanceof Path) {
            return this.path.equals(((Path)compareTo).path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }
}

