/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import se.natusoft.tools.optionsmgr.internal.OptionsAnnotationHelper;
import se.natusoft.tools.optionsmgr.internal.PropertyTypesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyInfo {
    private Method method = null;
    private Field field = null;
    private OptionsAnnotationHelper annotationHelper = null;

    public PropertyInfo(Method method) {
        this.method = method;
    }

    public PropertyInfo(Field field) {
        this.field = field;
    }

    public String getName() {
        String name = null;
        if (this.method != null) {
            name = this.method.getName().substring(3);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        } else {
            name = this.field.getName();
        }
        return name;
    }

    public Class<?> getType() {
        Class<?> type = null;
        type = this.method != null ? this.method.getParameterTypes()[0] : this.field.getType();
        return type;
    }

    public void setAnnotationHelper(OptionsAnnotationHelper annotationHelper) {
        this.annotationHelper = annotationHelper;
    }

    public OptionsAnnotationHelper getAnnotationHelper() {
        return this.annotationHelper;
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        T ann = null;
        ann = this.method != null ? (T)this.method.getAnnotation(clazz) : (T)this.field.getAnnotation(clazz);
        return ann;
    }

    public boolean isLeaf() {
        PropertyTypesHelper pth = PropertyTypesHelper.getInstance();
        boolean leaf = false;
        if (pth.isCollection(this.getType())) {
            Class realType;
            if (this.getAnnotationHelper().hasType() && pth.isValidPropertyType(realType = this.getAnnotationHelper().getType())) {
                leaf = true;
            }
        } else {
            leaf = pth.isValidPropertyType(this.getType());
        }
        return leaf;
    }

    public boolean isBranch() {
        PropertyTypesHelper pth = PropertyTypesHelper.getInstance();
        boolean branch = false;
        if (pth.isCollection(this.getType())) {
            Class realType;
            if (this.getAnnotationHelper().hasType() && !pth.isValidPropertyType(realType = this.getAnnotationHelper().getType())) {
                branch = true;
            }
        } else {
            branch = !pth.isValidPropertyType(this.getType());
        }
        return branch;
    }

    public String toString() {
        return "{name='" + this.getName() + "', type='" + this.getType() + "'}";
    }
}

