/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import se.natusoft.tools.optionsmgr.OptionsException;
import se.natusoft.tools.optionsmgr.OptionsModelException;
import se.natusoft.tools.optionsmgr.internal.EnumHelper;
import se.natusoft.tools.optionsmgr.internal.OMOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTypesHelper {
    private static PropertyTypesHelper propertyTypesHelper = new PropertyTypesHelper();
    private Type[] supportedTypes = new Type[]{new Type(String.class, "text"){

        protected Object stringToType(String value) {
            return value;
        }
    }, new Type(Integer.TYPE, Integer.class, "n"){

        protected Object stringToType(String value) {
            return Integer.valueOf(value);
        }
    }, new Type(Boolean.TYPE, Boolean.class, "true/false"){

        protected Object stringToType(String value) {
            return Boolean.valueOf(value);
        }
    }, new Type(Long.TYPE, Long.class, "n"){

        protected Object stringToType(String value) {
            return Long.valueOf(value);
        }
    }, new Type(Float.TYPE, Float.class, "n.n"){

        protected Object stringToType(String value) {
            return Float.valueOf(value);
        }
    }, new Type(Double.TYPE, Double.class, "n.n"){

        protected Object stringToType(String value) {
            return Double.valueOf(value);
        }
    }, new Type(Byte.TYPE, Byte.class, "n"){

        protected Object stringToType(String value) {
            return Byte.valueOf(value);
        }
    }, new Type(URL.class, "url"){

        protected Object stringToType(String value) {
            URL url = null;
            try {
                url = new URL(value);
            }
            catch (MalformedURLException mue) {
                this.fail("Bad url specification!");
            }
            return url;
        }
    }, new Type(Date.class, "date"){

        protected Object stringToType(String value) {
            Date date = this.getOMOptions().toDate(value);
            if (date == null && !this.hasConversionError()) {
                this.fail("Unknown date format '" + value + "'");
            }
            return date;
        }
    }, new Type(File.class, "path"){

        protected Object stringToType(String value) {
            return new File(value);
        }
    }, new Type(null, "(constrained text)"){

        public boolean isOfType(Class type) {
            return EnumHelper.isEnum(type);
        }

        public String getTypeDescription() {
            return "Any enum";
        }

        protected Object stringToType(String value, Class type) {
            EnumHelper enumHelper = new EnumHelper(type);
            Enum enm = enumHelper.getEnumForValue(value);
            if (enm == null) {
                this.fail("Invalid value '" + value + "'. Valid values are: " + enumHelper.getAvailableEnumsAsQuotedList() + ".");
            }
            return enm;
        }
    }};
    private OMOptions omOptions = null;

    private PropertyTypesHelper() {
    }

    public static PropertyTypesHelper getInstance() {
        return propertyTypesHelper;
    }

    public Type getSupportedType(Class type) {
        Type validType = null;
        for (Type supportedType : this.supportedTypes) {
            if (!supportedType.isOfType(type)) continue;
            validType = supportedType;
            break;
        }
        return validType;
    }

    public Object convertStringToTypeInstance(Class type, String value, OMOptions omOptions) throws OptionsException {
        this.omOptions = omOptions;
        Type supportedType = this.getSupportedType(type);
        if (supportedType != null) {
            return supportedType.convertStringToType(value, type);
        }
        throw new OptionsModelException("The property type (" + type + ") is not a supported type! Valid types are: " + this.getSupportedTypesAsQuotedList());
    }

    public boolean isValidPropertyType(Class type) {
        return this.getSupportedType(type) != null;
    }

    public boolean isEnum(Class type) {
        return EnumHelper.isEnum(type);
    }

    public boolean isCollection(Class type) {
        return Collection.class.isAssignableFrom(type);
    }

    public EnumHelper getEnumHelper(Class<? extends Enum> enumType) {
        return new EnumHelper(enumType);
    }

    public String getSupportedTypesAsQuotedList() {
        StringBuilder sb = new StringBuilder();
        String comma = "";
        for (Type supportedType : this.supportedTypes) {
            sb.append(comma);
            sb.append('\"');
            sb.append(supportedType.getTypeDescription());
            sb.append('\"');
            comma = ", ";
        }
        return sb.toString();
    }

    public String getTypeDescription(Class type) {
        String desc = "";
        Type supportedType = this.getSupportedType(type);
        if (supportedType != null) {
            desc = supportedType.getTypeDescription();
        }
        return desc;
    }

    public abstract class Type {
        private Class primitive = null;
        private Class object = null;
        private String valueTypeRepresentation = "";
        private String convertErrorMessage = null;

        public Type(Class primitive, Class object, String valueTypeRepresentation) {
            this.primitive = primitive;
            this.object = object;
            this.valueTypeRepresentation = valueTypeRepresentation;
        }

        public Type(Class type, String valueTypeRepresentation) {
            this.object = type;
            this.valueTypeRepresentation = valueTypeRepresentation;
        }

        public String getValueTypeRepresentation() {
            return this.valueTypeRepresentation;
        }

        public String getTypeDescription() {
            String desc = null;
            desc = this.primitive != null ? this.primitive.getSimpleName() + "/" + this.object.getSimpleName() : this.object.getSimpleName();
            return desc;
        }

        public boolean isOfType(Class type) {
            boolean isOfType = false;
            isOfType = this.primitive != null ? type.isAssignableFrom(this.primitive) || type.isAssignableFrom(this.object) : type.isAssignableFrom(this.object);
            return isOfType;
        }

        protected boolean hasConversionError() {
            return this.convertErrorMessage != null;
        }

        protected void fail(String errorMessage) {
            this.convertErrorMessage = errorMessage;
        }

        protected OMOptions getOMOptions() {
            return PropertyTypesHelper.this.omOptions;
        }

        public Object convertStringToType(String value, Class type) throws OptionsException {
            this.convertErrorMessage = null;
            Object result = this.stringToType(value);
            if (result == null) {
                result = this.stringToType(value, type);
            }
            if (this.hasConversionError()) {
                throw new OptionsException(this.convertErrorMessage);
            }
            return result;
        }

        protected Object stringToType(String value) {
            return null;
        }

        protected Object stringToType(String value, Class type) {
            return null;
        }
    }
}

