/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal;

public class PropertyValueValidator {
    private String validate = null;
    private String[] validValues = null;

    public PropertyValueValidator(String validate) {
        this.validate = validate;
    }

    public PropertyValueValidator(String[] validValues) {
        this.validValues = validValues;
    }

    public PropertyValueValidator() {
    }

    public boolean hasValidation() {
        return this.validate != null || this.validValues != null;
    }

    public boolean isValid(String value) {
        boolean valid = true;
        if (this.validate != null) {
            valid = value.matches(this.validate);
        } else if (this.validValues != null) {
            valid = false;
            for (String validValue : this.validValues) {
                if (!value.equals(validValue)) continue;
                valid = true;
                break;
            }
        }
        return valid;
    }

    public String getMustMatchText() {
        String mustMatch = "";
        if (this.validate != null) {
            mustMatch = "Value must match \"" + this.validate + "\"";
        } else if (this.validValues != null) {
            StringBuilder sb = new StringBuilder();
            String comma = "";
            for (String validValue : this.validValues) {
                sb.append(comma);
                sb.append('\"');
                sb.append(validValue);
                sb.append('\"');
                comma = ", ";
            }
            mustMatch = "Value must be one of the following values: " + sb.toString();
        }
        return mustMatch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PropertyValueValidator {");
        if (this.validate != null) {
            sb.append("validate=\"");
            sb.append(this.validate);
            sb.append("\"");
        } else if (this.validValues != null) {
            sb.append("validValues=[");
            String comma = "";
            for (String validValue : this.validValues) {
                sb.append(comma);
                sb.append(validValue);
                comma = ", ";
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }
}

