/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.tools.optionsmgr.internal.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import se.natusoft.tools.optionsmgr.OptionsException;
import se.natusoft.tools.optionsmgr.internal.utils.XMLAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElement {
    private String name = null;
    private String value = null;
    private List<XMLElement> children = new ArrayList<XMLElement>();
    private Map<String, XMLAttribute> attributes = new HashMap<String, XMLAttribute>();
    private StringBuilder comments = new StringBuilder();

    public XMLElement(String name) {
        this.name = name;
    }

    public XMLElement(Element element) throws OptionsException {
        try {
            this.setName(element.getTagName());
            if (element.hasAttributes()) {
                NamedNodeMap attrs = element.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    XMLAttribute xmlAttr = new XMLAttribute(attr);
                    this.attributes.put(attr.getName(), xmlAttr);
                }
            }
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() == 3) {
                    if (this.value != null) {
                        this.value = this.value + node.getNodeValue();
                        continue;
                    }
                    this.value = node.getNodeValue();
                    continue;
                }
                if (node.getNodeType() == 1) {
                    XMLElement childElement = new XMLElement((Element)node);
                    this.children.add(childElement);
                    continue;
                }
                if (node.getNodeType() != 8) continue;
                this.comments.append(node.getNodeValue());
            }
        }
        catch (Exception e) {
            throw new OptionsException("Failed to create an XMLElement from DOM Element!", e);
        }
        if (this.value != null) {
            this.value = this.value.trim();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<XMLElement> getChildElements() {
        return this.children;
    }

    public boolean elementHasChildren() {
        return this.children.size() > 0;
    }

    public Collection<XMLAttribute> getAttributes() {
        return this.attributes.values();
    }

    public XMLAttribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setElementValue(String value) {
        this.value = value;
    }

    public String getElementValue() {
        return this.value;
    }

    public boolean elementHasValue() {
        return this.value != null && this.value.trim().length() > 0;
    }

    public String getComments() {
        return this.comments.toString();
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("<");
        sb.append(this.getName());
        sb.append(">\n");
        sb.append(indent);
        sb.append("    ");
        sb.append(this.getElementValue());
        sb.append("\n");
        for (XMLElement child : this.getChildElements()) {
            sb.append(child.toString(indent + "    "));
        }
        sb.append(indent);
        sb.append("</");
        sb.append(this.getName());
        sb.append(">\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

