/*
 * Decompiled with CFR 0.152.
 */
package site.howaric.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FieldUtil.class);

    public static List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        if (clazz == null) {
            return allFields;
        }
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = currentClass.getDeclaredFields()) {
                allFields.add(field);
            }
        }
        return allFields;
    }

    public static Object getFieldValue(Field field, Object target) {
        field.setAccessible(true);
        try {
            return field.get(target);
        }
        catch (IllegalAccessException e) {
            LOG.error("Get value of field failed", (Throwable)e);
            return null;
        }
    }

    public static void setFieldValue(Field field, Object target, Object value) {
        field.setAccessible(true);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            LOG.error("Set value of field failed", (Throwable)e);
        }
    }
}

