/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.QueryStatisticsForDescribeQuery;
import software.amazon.awssdk.services.cloudtrail.model.QueryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeQueryResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, DescribeQueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(DescribeQueryResponse.getter(DescribeQueryResponse::queryId)).setter(DescribeQueryResponse.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(DescribeQueryResponse.getter(DescribeQueryResponse::queryString)).setter(DescribeQueryResponse.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryStatus").getter(DescribeQueryResponse.getter(DescribeQueryResponse::queryStatusAsString)).setter(DescribeQueryResponse.setter(Builder::queryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()}).build();
    private static final SdkField<QueryStatisticsForDescribeQuery> QUERY_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryStatistics").getter(DescribeQueryResponse.getter(DescribeQueryResponse::queryStatistics)).setter(DescribeQueryResponse.setter(Builder::queryStatistics)).constructor(QueryStatisticsForDescribeQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatistics").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(DescribeQueryResponse.getter(DescribeQueryResponse::errorMessage)).setter(DescribeQueryResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, QUERY_STRING_FIELD, QUERY_STATUS_FIELD, QUERY_STATISTICS_FIELD, ERROR_MESSAGE_FIELD));
    private final String queryId;
    private final String queryString;
    private final String queryStatus;
    private final QueryStatisticsForDescribeQuery queryStatistics;
    private final String errorMessage;

    private DescribeQueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.queryString = builder.queryString;
        this.queryStatus = builder.queryStatus;
        this.queryStatistics = builder.queryStatistics;
        this.errorMessage = builder.errorMessage;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final QueryStatus queryStatus() {
        return QueryStatus.fromValue(this.queryStatus);
    }

    public final String queryStatusAsString() {
        return this.queryStatus;
    }

    public final QueryStatisticsForDescribeQuery queryStatistics() {
        return this.queryStatistics;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQueryResponse)) {
            return false;
        }
        DescribeQueryResponse other = (DescribeQueryResponse)((Object)obj);
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.queryStatusAsString(), other.queryStatusAsString()) && Objects.equals(this.queryStatistics(), other.queryStatistics()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeQueryResponse").add("QueryId", (Object)this.queryId()).add("QueryString", (Object)this.queryString()).add("QueryStatus", (Object)this.queryStatusAsString()).add("QueryStatistics", (Object)this.queryStatistics()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "QueryStatus": {
                return Optional.ofNullable(clazz.cast(this.queryStatusAsString()));
            }
            case "QueryStatistics": {
                return Optional.ofNullable(clazz.cast(this.queryStatistics()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeQueryResponse, T> g) {
        return obj -> g.apply((DescribeQueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String queryId;
        private String queryString;
        private String queryStatus;
        private QueryStatisticsForDescribeQuery queryStatistics;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQueryResponse model) {
            super(model);
            this.queryId(model.queryId);
            this.queryString(model.queryString);
            this.queryStatus(model.queryStatus);
            this.queryStatistics(model.queryStatistics);
            this.errorMessage(model.errorMessage);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        @Transient
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        @Transient
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getQueryStatus() {
            return this.queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        @Transient
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        public final QueryStatisticsForDescribeQuery.Builder getQueryStatistics() {
            return this.queryStatistics != null ? this.queryStatistics.toBuilder() : null;
        }

        public final void setQueryStatistics(QueryStatisticsForDescribeQuery.BuilderImpl queryStatistics) {
            this.queryStatistics = queryStatistics != null ? queryStatistics.build() : null;
        }

        @Override
        @Transient
        public final Builder queryStatistics(QueryStatisticsForDescribeQuery queryStatistics) {
            this.queryStatistics = queryStatistics;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public DescribeQueryResponse build() {
            return new DescribeQueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeQueryResponse> {
        public Builder queryId(String var1);

        public Builder queryString(String var1);

        public Builder queryStatus(String var1);

        public Builder queryStatus(QueryStatus var1);

        public Builder queryStatistics(QueryStatisticsForDescribeQuery var1);

        default public Builder queryStatistics(Consumer<QueryStatisticsForDescribeQuery.Builder> queryStatistics) {
            return this.queryStatistics((QueryStatisticsForDescribeQuery)((QueryStatisticsForDescribeQuery.Builder)QueryStatisticsForDescribeQuery.builder().applyMutation(queryStatistics)).build());
        }

        public Builder errorMessage(String var1);
    }
}

