/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Attachment;
import software.amazon.awssdk.services.ecs.model.AttachmentsCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.ClusterConfiguration;
import software.amazon.awssdk.services.ecs.model.ClusterSetting;
import software.amazon.awssdk.services.ecs.model.ClusterSettingsCopier;
import software.amazon.awssdk.services.ecs.model.KeyValuePair;
import software.amazon.awssdk.services.ecs.model.StatisticsCopier;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(Cluster.getter(Cluster::clusterArn)).setter(Cluster.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(Cluster.getter(Cluster::clusterName)).setter(Cluster.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<ClusterConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(Cluster.getter(Cluster::configuration)).setter(Cluster.setter(Builder::configuration)).constructor(ClusterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Cluster.getter(Cluster::status)).setter(Cluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("registeredContainerInstancesCount").getter(Cluster.getter(Cluster::registeredContainerInstancesCount)).setter(Cluster.setter(Builder::registeredContainerInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredContainerInstancesCount").build()}).build();
    private static final SdkField<Integer> RUNNING_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("runningTasksCount").getter(Cluster.getter(Cluster::runningTasksCount)).setter(Cluster.setter(Builder::runningTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningTasksCount").build()}).build();
    private static final SdkField<Integer> PENDING_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pendingTasksCount").getter(Cluster.getter(Cluster::pendingTasksCount)).setter(Cluster.setter(Builder::pendingTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingTasksCount").build()}).build();
    private static final SdkField<Integer> ACTIVE_SERVICES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("activeServicesCount").getter(Cluster.getter(Cluster::activeServicesCount)).setter(Cluster.setter(Builder::activeServicesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeServicesCount").build()}).build();
    private static final SdkField<List<KeyValuePair>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statistics").getter(Cluster.getter(Cluster::statistics)).setter(Cluster.setter(Builder::statistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Cluster.getter(Cluster::tags)).setter(Cluster.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ClusterSetting>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("settings").getter(Cluster.getter(Cluster::settings)).setter(Cluster.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CAPACITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviders").getter(Cluster.getter(Cluster::capacityProviders)).setter(Cluster.setter(Builder::capacityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("defaultCapacityProviderStrategy").getter(Cluster.getter(Cluster::defaultCapacityProviderStrategy)).setter(Cluster.setter(Builder::defaultCapacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCapacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attachments").getter(Cluster.getter(Cluster::attachments)).setter(Cluster.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ATTACHMENTS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentsStatus").getter(Cluster.getter(Cluster::attachmentsStatus)).setter(Cluster.setter(Builder::attachmentsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, CONFIGURATION_FIELD, STATUS_FIELD, REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD, RUNNING_TASKS_COUNT_FIELD, PENDING_TASKS_COUNT_FIELD, ACTIVE_SERVICES_COUNT_FIELD, STATISTICS_FIELD, TAGS_FIELD, SETTINGS_FIELD, CAPACITY_PROVIDERS_FIELD, DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD, ATTACHMENTS_FIELD, ATTACHMENTS_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final String clusterName;
    private final ClusterConfiguration configuration;
    private final String status;
    private final Integer registeredContainerInstancesCount;
    private final Integer runningTasksCount;
    private final Integer pendingTasksCount;
    private final Integer activeServicesCount;
    private final List<KeyValuePair> statistics;
    private final List<Tag> tags;
    private final List<ClusterSetting> settings;
    private final List<String> capacityProviders;
    private final List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy;
    private final List<Attachment> attachments;
    private final String attachmentsStatus;

    private Cluster(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.configuration = builder.configuration;
        this.status = builder.status;
        this.registeredContainerInstancesCount = builder.registeredContainerInstancesCount;
        this.runningTasksCount = builder.runningTasksCount;
        this.pendingTasksCount = builder.pendingTasksCount;
        this.activeServicesCount = builder.activeServicesCount;
        this.statistics = builder.statistics;
        this.tags = builder.tags;
        this.settings = builder.settings;
        this.capacityProviders = builder.capacityProviders;
        this.defaultCapacityProviderStrategy = builder.defaultCapacityProviderStrategy;
        this.attachments = builder.attachments;
        this.attachmentsStatus = builder.attachmentsStatus;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final ClusterConfiguration configuration() {
        return this.configuration;
    }

    public final String status() {
        return this.status;
    }

    public final Integer registeredContainerInstancesCount() {
        return this.registeredContainerInstancesCount;
    }

    public final Integer runningTasksCount() {
        return this.runningTasksCount;
    }

    public final Integer pendingTasksCount() {
        return this.pendingTasksCount;
    }

    public final Integer activeServicesCount() {
        return this.activeServicesCount;
    }

    public final boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public final List<KeyValuePair> statistics() {
        return this.statistics;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasSettings() {
        return this.settings != null && !(this.settings instanceof SdkAutoConstructList);
    }

    public final List<ClusterSetting> settings() {
        return this.settings;
    }

    public final boolean hasCapacityProviders() {
        return this.capacityProviders != null && !(this.capacityProviders instanceof SdkAutoConstructList);
    }

    public final List<String> capacityProviders() {
        return this.capacityProviders;
    }

    public final boolean hasDefaultCapacityProviderStrategy() {
        return this.defaultCapacityProviderStrategy != null && !(this.defaultCapacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy() {
        return this.defaultCapacityProviderStrategy;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<Attachment> attachments() {
        return this.attachments;
    }

    public final String attachmentsStatus() {
        return this.attachmentsStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredContainerInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeServicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatistics() ? this.statistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSettings() ? this.settings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviders() ? this.capacityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultCapacityProviderStrategy() ? this.defaultCapacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentsStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.registeredContainerInstancesCount(), other.registeredContainerInstancesCount()) && Objects.equals(this.runningTasksCount(), other.runningTasksCount()) && Objects.equals(this.pendingTasksCount(), other.pendingTasksCount()) && Objects.equals(this.activeServicesCount(), other.activeServicesCount()) && this.hasStatistics() == other.hasStatistics() && Objects.equals(this.statistics(), other.statistics()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasSettings() == other.hasSettings() && Objects.equals(this.settings(), other.settings()) && this.hasCapacityProviders() == other.hasCapacityProviders() && Objects.equals(this.capacityProviders(), other.capacityProviders()) && this.hasDefaultCapacityProviderStrategy() == other.hasDefaultCapacityProviderStrategy() && Objects.equals(this.defaultCapacityProviderStrategy(), other.defaultCapacityProviderStrategy()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.attachmentsStatus(), other.attachmentsStatus());
    }

    public final String toString() {
        return ToString.builder((String)"Cluster").add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("Configuration", (Object)this.configuration()).add("Status", (Object)this.status()).add("RegisteredContainerInstancesCount", (Object)this.registeredContainerInstancesCount()).add("RunningTasksCount", (Object)this.runningTasksCount()).add("PendingTasksCount", (Object)this.pendingTasksCount()).add("ActiveServicesCount", (Object)this.activeServicesCount()).add("Statistics", this.hasStatistics() ? this.statistics() : null).add("Tags", this.hasTags() ? this.tags() : null).add("Settings", this.hasSettings() ? this.settings() : null).add("CapacityProviders", this.hasCapacityProviders() ? this.capacityProviders() : null).add("DefaultCapacityProviderStrategy", this.hasDefaultCapacityProviderStrategy() ? this.defaultCapacityProviderStrategy() : null).add("Attachments", this.hasAttachments() ? this.attachments() : null).add("AttachmentsStatus", (Object)this.attachmentsStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "registeredContainerInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.registeredContainerInstancesCount()));
            }
            case "runningTasksCount": {
                return Optional.ofNullable(clazz.cast(this.runningTasksCount()));
            }
            case "pendingTasksCount": {
                return Optional.ofNullable(clazz.cast(this.pendingTasksCount()));
            }
            case "activeServicesCount": {
                return Optional.ofNullable(clazz.cast(this.activeServicesCount()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "capacityProviders": {
                return Optional.ofNullable(clazz.cast(this.capacityProviders()));
            }
            case "defaultCapacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.defaultCapacityProviderStrategy()));
            }
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "attachmentsStatus": {
                return Optional.ofNullable(clazz.cast(this.attachmentsStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private String clusterName;
        private ClusterConfiguration configuration;
        private String status;
        private Integer registeredContainerInstancesCount;
        private Integer runningTasksCount;
        private Integer pendingTasksCount;
        private Integer activeServicesCount;
        private List<KeyValuePair> statistics = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<ClusterSetting> settings = DefaultSdkAutoConstructList.getInstance();
        private List<String> capacityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private List<Attachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private String attachmentsStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.configuration(model.configuration);
            this.status(model.status);
            this.registeredContainerInstancesCount(model.registeredContainerInstancesCount);
            this.runningTasksCount(model.runningTasksCount);
            this.pendingTasksCount(model.pendingTasksCount);
            this.activeServicesCount(model.activeServicesCount);
            this.statistics(model.statistics);
            this.tags(model.tags);
            this.settings(model.settings);
            this.capacityProviders(model.capacityProviders);
            this.defaultCapacityProviderStrategy(model.defaultCapacityProviderStrategy);
            this.attachments(model.attachments);
            this.attachmentsStatus(model.attachmentsStatus);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        @Transient
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        @Transient
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final ClusterConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ClusterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(ClusterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getRegisteredContainerInstancesCount() {
            return this.registeredContainerInstancesCount;
        }

        public final void setRegisteredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
        }

        @Override
        @Transient
        public final Builder registeredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
            return this;
        }

        public final Integer getRunningTasksCount() {
            return this.runningTasksCount;
        }

        public final void setRunningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
        }

        @Override
        @Transient
        public final Builder runningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
            return this;
        }

        public final Integer getPendingTasksCount() {
            return this.pendingTasksCount;
        }

        public final void setPendingTasksCount(Integer pendingTasksCount) {
            this.pendingTasksCount = pendingTasksCount;
        }

        @Override
        @Transient
        public final Builder pendingTasksCount(Integer pendingTasksCount) {
            this.pendingTasksCount = pendingTasksCount;
            return this;
        }

        public final Integer getActiveServicesCount() {
            return this.activeServicesCount;
        }

        public final void setActiveServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
        }

        @Override
        @Transient
        public final Builder activeServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
            return this;
        }

        public final List<KeyValuePair.Builder> getStatistics() {
            List<KeyValuePair.Builder> result = StatisticsCopier.copyToBuilder(this.statistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatistics(Collection<KeyValuePair.BuilderImpl> statistics) {
            this.statistics = StatisticsCopier.copyFromBuilder(statistics);
        }

        @Override
        @Transient
        public final Builder statistics(Collection<KeyValuePair> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statistics(KeyValuePair ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statistics(Consumer<KeyValuePair.Builder> ... statistics) {
            this.statistics(Stream.of(statistics).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClusterSetting.Builder> getSettings() {
            List<ClusterSetting.Builder> result = ClusterSettingsCopier.copyToBuilder(this.settings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSettings(Collection<ClusterSetting.BuilderImpl> settings) {
            this.settings = ClusterSettingsCopier.copyFromBuilder(settings);
        }

        @Override
        @Transient
        public final Builder settings(Collection<ClusterSetting> settings) {
            this.settings = ClusterSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(ClusterSetting ... settings) {
            this.settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(Consumer<ClusterSetting.Builder> ... settings) {
            this.settings(Stream.of(settings).map(c -> (ClusterSetting)((ClusterSetting.Builder)ClusterSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCapacityProviders() {
            if (this.capacityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityProviders;
        }

        public final void setCapacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
        }

        @Override
        @Transient
        public final Builder capacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder capacityProviders(String ... capacityProviders) {
            this.capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getDefaultCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier.copyToBuilder(this.defaultCapacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(defaultCapacityProviderStrategy);
        }

        @Override
        @Transient
        public final Builder defaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = CapacityProviderStrategyCopier.copy(defaultCapacityProviderStrategy);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(CapacityProviderStrategyItem ... defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy(Arrays.asList(defaultCapacityProviderStrategy));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy(Stream.of(defaultCapacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Attachment.Builder> getAttachments() {
            List<Attachment.Builder> result = AttachmentsCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<Attachment.BuilderImpl> attachments) {
            this.attachments = AttachmentsCopier.copyFromBuilder(attachments);
        }

        @Override
        @Transient
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachments(Attachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachments(Consumer<Attachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (Attachment)((Attachment.Builder)Attachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAttachmentsStatus() {
            return this.attachmentsStatus;
        }

        public final void setAttachmentsStatus(String attachmentsStatus) {
            this.attachmentsStatus = attachmentsStatus;
        }

        @Override
        @Transient
        public final Builder attachmentsStatus(String attachmentsStatus) {
            this.attachmentsStatus = attachmentsStatus;
            return this;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder configuration(ClusterConfiguration var1);

        default public Builder configuration(Consumer<ClusterConfiguration.Builder> configuration) {
            return this.configuration((ClusterConfiguration)((ClusterConfiguration.Builder)ClusterConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder status(String var1);

        public Builder registeredContainerInstancesCount(Integer var1);

        public Builder runningTasksCount(Integer var1);

        public Builder pendingTasksCount(Integer var1);

        public Builder activeServicesCount(Integer var1);

        public Builder statistics(Collection<KeyValuePair> var1);

        public Builder statistics(KeyValuePair ... var1);

        public Builder statistics(Consumer<KeyValuePair.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder settings(Collection<ClusterSetting> var1);

        public Builder settings(ClusterSetting ... var1);

        public Builder settings(Consumer<ClusterSetting.Builder> ... var1);

        public Builder capacityProviders(Collection<String> var1);

        public Builder capacityProviders(String ... var1);

        public Builder defaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder defaultCapacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder defaultCapacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder attachments(Collection<Attachment> var1);

        public Builder attachments(Attachment ... var1);

        public Builder attachments(Consumer<Attachment.Builder> ... var1);

        public Builder attachmentsStatus(String var1);
    }
}

