/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PidMode {
    HOST("host"),
    TASK("task"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PidMode> VALUE_MAP;
    private final String value;

    private PidMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PidMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PidMode> knownValues() {
        EnumSet<PidMode> knownValues = EnumSet.allOf(PidMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PidMode.class, PidMode::toString);
    }
}

