/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.AutoScalingGroupProviderUpdate;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCapacityProviderRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, UpdateCapacityProviderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateCapacityProviderRequest.getter(UpdateCapacityProviderRequest::name)).setter(UpdateCapacityProviderRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<AutoScalingGroupProviderUpdate> AUTO_SCALING_GROUP_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoScalingGroupProvider").getter(UpdateCapacityProviderRequest.getter(UpdateCapacityProviderRequest::autoScalingGroupProvider)).setter(UpdateCapacityProviderRequest.setter(Builder::autoScalingGroupProvider)).constructor(AutoScalingGroupProviderUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, AUTO_SCALING_GROUP_PROVIDER_FIELD));
    private final String name;
    private final AutoScalingGroupProviderUpdate autoScalingGroupProvider;

    private UpdateCapacityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.autoScalingGroupProvider = builder.autoScalingGroupProvider;
    }

    public final String name() {
        return this.name;
    }

    public final AutoScalingGroupProviderUpdate autoScalingGroupProvider() {
        return this.autoScalingGroupProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupProvider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapacityProviderRequest)) {
            return false;
        }
        UpdateCapacityProviderRequest other = (UpdateCapacityProviderRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.autoScalingGroupProvider(), other.autoScalingGroupProvider());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCapacityProviderRequest").add("Name", (Object)this.name()).add("AutoScalingGroupProvider", (Object)this.autoScalingGroupProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "autoScalingGroupProvider": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupProvider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapacityProviderRequest, T> g) {
        return obj -> g.apply((UpdateCapacityProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String name;
        private AutoScalingGroupProviderUpdate autoScalingGroupProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapacityProviderRequest model) {
            super(model);
            this.name(model.name);
            this.autoScalingGroupProvider(model.autoScalingGroupProvider);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AutoScalingGroupProviderUpdate.Builder getAutoScalingGroupProvider() {
            return this.autoScalingGroupProvider != null ? this.autoScalingGroupProvider.toBuilder() : null;
        }

        public final void setAutoScalingGroupProvider(AutoScalingGroupProviderUpdate.BuilderImpl autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider != null ? autoScalingGroupProvider.build() : null;
        }

        @Override
        @Transient
        public final Builder autoScalingGroupProvider(AutoScalingGroupProviderUpdate autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCapacityProviderRequest build() {
            return new UpdateCapacityProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCapacityProviderRequest> {
        public Builder name(String var1);

        public Builder autoScalingGroupProvider(AutoScalingGroupProviderUpdate var1);

        default public Builder autoScalingGroupProvider(Consumer<AutoScalingGroupProviderUpdate.Builder> autoScalingGroupProvider) {
            return this.autoScalingGroupProvider((AutoScalingGroupProviderUpdate)((AutoScalingGroupProviderUpdate.Builder)AutoScalingGroupProviderUpdate.builder().applyMutation(autoScalingGroupProvider)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

