/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest;
import software.amazon.awssdk.services.ecs.model.ListAccountSettingsResponse;
import software.amazon.awssdk.services.ecs.model.Setting;

public class ListAccountSettingsPublisher
implements SdkPublisher<ListAccountSettingsResponse> {
    private final EcsAsyncClient client;
    private final ListAccountSettingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountSettingsPublisher(EcsAsyncClient client, ListAccountSettingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountSettingsPublisher(EcsAsyncClient client, ListAccountSettingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountSettingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountSettingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Setting> settings() {
        Function<ListAccountSettingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.settings() != null) {
                return response.settings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountSettingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountSettingsResponseFetcher
    implements AsyncPageFetcher<ListAccountSettingsResponse> {
        private ListAccountSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountSettingsResponse> nextPage(ListAccountSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountSettingsPublisher.this.client.listAccountSettings(ListAccountSettingsPublisher.this.firstRequest);
            }
            return ListAccountSettingsPublisher.this.client.listAccountSettings((ListAccountSettingsRequest)((Object)ListAccountSettingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

