/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.model.ListTasksRequest;
import software.amazon.awssdk.services.ecs.model.ListTasksResponse;

public class ListTasksIterable
implements SdkIterable<ListTasksResponse> {
    private final EcsClient client;
    private final ListTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTasksIterable(EcsClient client, ListTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTasksResponseFetcher();
    }

    public Iterator<ListTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> taskArns() {
        Function<ListTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskArns() != null) {
                return response.taskArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTasksResponseFetcher
    implements SyncPageFetcher<ListTasksResponse> {
        private ListTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTasksResponse nextPage(ListTasksResponse previousPage) {
            if (previousPage == null) {
                return ListTasksIterable.this.client.listTasks(ListTasksIterable.this.firstRequest);
            }
            return ListTasksIterable.this.client.listTasks((ListTasksRequest)((Object)ListTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

