/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.HttpEndpointBufferingHints;
import software.amazon.awssdk.services.firehose.model.HttpEndpointDescription;
import software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration;
import software.amazon.awssdk.services.firehose.model.HttpEndpointRetryOptions;
import software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpEndpointDestinationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpEndpointDestinationDescription> {
    private static final SdkField<HttpEndpointDescription> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointConfiguration").getter(HttpEndpointDestinationDescription.getter(HttpEndpointDestinationDescription::endpointConfiguration)).setter(HttpEndpointDestinationDescription.setter(Builder::endpointConfiguration)).constructor(HttpEndpointDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfiguration").build()}).build();
    private static final SdkField<HttpEndpointBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(HttpEndpointDestinationDescription.getter(HttpEndpointDestinationDescription::bufferingHints)).setter(HttpEndpointDestinationDescription.setter(Builder::bufferingHints)).constructor(HttpEndpointBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(HttpEndpointDestinationDescription.getter(HttpEndpointDestinationDescription::cloudWatchLoggingOptions)).setter(HttpEndpointDestinationDescription.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<HttpEndpointRequestConfiguration> REQUEST_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestConfiguration").getter(HttpEndpointDestinationDescription.getter(HttpEndpointDestinationDescription::requestConfiguration)).setter(HttpEndpointDestinationDescription.setter(Builder::requestConfiguration)).constructor(HttpEndpointRequestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestConfiguration").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(HttpEndpointDestinationDescription.getter(HttpEndpointDestinationDescription::processingConfiguration)).setter(HttpEndpointDestinationDescription.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(HttpEndpointDestinationDescription.getter(HttpEndpointDestinationDescription::roleARN)).setter(HttpEndpointDestinationDescription.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<HttpEndpointRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(HttpEndpointDestinationDescription.getter(HttpEndpointDestinationDescription::retryOptions)).setter(HttpEndpointDestinationDescription.setter(Builder::retryOptions)).constructor(HttpEndpointRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(HttpEndpointDestinationDescription.getter(HttpEndpointDestinationDescription::s3BackupModeAsString)).setter(HttpEndpointDestinationDescription.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationDescription> S3_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3DestinationDescription").getter(HttpEndpointDestinationDescription.getter(HttpEndpointDestinationDescription::s3DestinationDescription)).setter(HttpEndpointDestinationDescription.setter(Builder::s3DestinationDescription)).constructor(S3DestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIGURATION_FIELD, BUFFERING_HINTS_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, REQUEST_CONFIGURATION_FIELD, PROCESSING_CONFIGURATION_FIELD, ROLE_ARN_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_DESTINATION_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final HttpEndpointDescription endpointConfiguration;
    private final HttpEndpointBufferingHints bufferingHints;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final HttpEndpointRequestConfiguration requestConfiguration;
    private final ProcessingConfiguration processingConfiguration;
    private final String roleARN;
    private final HttpEndpointRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationDescription s3DestinationDescription;

    private HttpEndpointDestinationDescription(BuilderImpl builder) {
        this.endpointConfiguration = builder.endpointConfiguration;
        this.bufferingHints = builder.bufferingHints;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.requestConfiguration = builder.requestConfiguration;
        this.processingConfiguration = builder.processingConfiguration;
        this.roleARN = builder.roleARN;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3DestinationDescription = builder.s3DestinationDescription;
    }

    public final HttpEndpointDescription endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public final HttpEndpointBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final HttpEndpointRequestConfiguration requestConfiguration() {
        return this.requestConfiguration;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final HttpEndpointRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final HttpEndpointS3BackupMode s3BackupMode() {
        return HttpEndpointS3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationDescription s3DestinationDescription() {
        return this.s3DestinationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpEndpointDestinationDescription)) {
            return false;
        }
        HttpEndpointDestinationDescription other = (HttpEndpointDestinationDescription)obj;
        return Objects.equals(this.endpointConfiguration(), other.endpointConfiguration()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.requestConfiguration(), other.requestConfiguration()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3DestinationDescription(), other.s3DestinationDescription());
    }

    public final String toString() {
        return ToString.builder((String)"HttpEndpointDestinationDescription").add("EndpointConfiguration", (Object)this.endpointConfiguration()).add("BufferingHints", (Object)this.bufferingHints()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("RequestConfiguration", (Object)this.requestConfiguration()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("RoleARN", (Object)this.roleARN()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3DestinationDescription", (Object)this.s3DestinationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "RequestConfiguration": {
                return Optional.ofNullable(clazz.cast(this.requestConfiguration()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3DestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpEndpointDestinationDescription, T> g) {
        return obj -> g.apply((HttpEndpointDestinationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HttpEndpointDescription endpointConfiguration;
        private HttpEndpointBufferingHints bufferingHints;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private HttpEndpointRequestConfiguration requestConfiguration;
        private ProcessingConfiguration processingConfiguration;
        private String roleARN;
        private HttpEndpointRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationDescription s3DestinationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpEndpointDestinationDescription model) {
            this.endpointConfiguration(model.endpointConfiguration);
            this.bufferingHints(model.bufferingHints);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.requestConfiguration(model.requestConfiguration);
            this.processingConfiguration(model.processingConfiguration);
            this.roleARN(model.roleARN);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3DestinationDescription(model.s3DestinationDescription);
        }

        public final HttpEndpointDescription.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(HttpEndpointDescription.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder endpointConfiguration(HttpEndpointDescription endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final HttpEndpointBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(HttpEndpointBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        @Transient
        public final Builder bufferingHints(HttpEndpointBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final HttpEndpointRequestConfiguration.Builder getRequestConfiguration() {
            return this.requestConfiguration != null ? this.requestConfiguration.toBuilder() : null;
        }

        public final void setRequestConfiguration(HttpEndpointRequestConfiguration.BuilderImpl requestConfiguration) {
            this.requestConfiguration = requestConfiguration != null ? requestConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder requestConfiguration(HttpEndpointRequestConfiguration requestConfiguration) {
            this.requestConfiguration = requestConfiguration;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        @Transient
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final HttpEndpointRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(HttpEndpointRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder retryOptions(HttpEndpointRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        @Transient
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        @Transient
        public final Builder s3BackupMode(HttpEndpointS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return this.s3DestinationDescription != null ? this.s3DestinationDescription.toBuilder() : null;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public HttpEndpointDestinationDescription build() {
            return new HttpEndpointDestinationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpEndpointDestinationDescription> {
        public Builder endpointConfiguration(HttpEndpointDescription var1);

        default public Builder endpointConfiguration(Consumer<HttpEndpointDescription.Builder> endpointConfiguration) {
            return this.endpointConfiguration((HttpEndpointDescription)((HttpEndpointDescription.Builder)HttpEndpointDescription.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder bufferingHints(HttpEndpointBufferingHints var1);

        default public Builder bufferingHints(Consumer<HttpEndpointBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((HttpEndpointBufferingHints)((HttpEndpointBufferingHints.Builder)HttpEndpointBufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder requestConfiguration(HttpEndpointRequestConfiguration var1);

        default public Builder requestConfiguration(Consumer<HttpEndpointRequestConfiguration.Builder> requestConfiguration) {
            return this.requestConfiguration((HttpEndpointRequestConfiguration)((HttpEndpointRequestConfiguration.Builder)HttpEndpointRequestConfiguration.builder().applyMutation(requestConfiguration)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder roleARN(String var1);

        public Builder retryOptions(HttpEndpointRetryOptions var1);

        default public Builder retryOptions(Consumer<HttpEndpointRetryOptions.Builder> retryOptions) {
            return this.retryOptions((HttpEndpointRetryOptions)((HttpEndpointRetryOptions.Builder)HttpEndpointRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(HttpEndpointS3BackupMode var1);

        public Builder s3DestinationDescription(S3DestinationDescription var1);

        default public Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return this.s3DestinationDescription((S3DestinationDescription)((S3DestinationDescription.Builder)S3DestinationDescription.builder().applyMutation(s3DestinationDescription)).build());
        }
    }
}

