/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServerStrategiesCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServerStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServerStrategiesResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, GetServerStrategiesResponse> {
    private static final SdkField<List<ServerStrategy>> SERVER_STRATEGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serverStrategies").getter(GetServerStrategiesResponse.getter(GetServerStrategiesResponse::serverStrategies)).setter(GetServerStrategiesResponse.setter(Builder::serverStrategies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverStrategies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_STRATEGIES_FIELD));
    private final List<ServerStrategy> serverStrategies;

    private GetServerStrategiesResponse(BuilderImpl builder) {
        super(builder);
        this.serverStrategies = builder.serverStrategies;
    }

    public final boolean hasServerStrategies() {
        return this.serverStrategies != null && !(this.serverStrategies instanceof SdkAutoConstructList);
    }

    public final List<ServerStrategy> serverStrategies() {
        return this.serverStrategies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerStrategies() ? this.serverStrategies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServerStrategiesResponse)) {
            return false;
        }
        GetServerStrategiesResponse other = (GetServerStrategiesResponse)((Object)obj);
        return this.hasServerStrategies() == other.hasServerStrategies() && Objects.equals(this.serverStrategies(), other.serverStrategies());
    }

    public final String toString() {
        return ToString.builder((String)"GetServerStrategiesResponse").add("ServerStrategies", this.hasServerStrategies() ? this.serverStrategies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serverStrategies": {
                return Optional.ofNullable(clazz.cast(this.serverStrategies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServerStrategiesResponse, T> g) {
        return obj -> g.apply((GetServerStrategiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private List<ServerStrategy> serverStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetServerStrategiesResponse model) {
            super(model);
            this.serverStrategies(model.serverStrategies);
        }

        public final List<ServerStrategy.Builder> getServerStrategies() {
            List<ServerStrategy.Builder> result = ServerStrategiesCopier.copyToBuilder(this.serverStrategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerStrategies(Collection<ServerStrategy.BuilderImpl> serverStrategies) {
            this.serverStrategies = ServerStrategiesCopier.copyFromBuilder(serverStrategies);
        }

        @Override
        @Transient
        public final Builder serverStrategies(Collection<ServerStrategy> serverStrategies) {
            this.serverStrategies = ServerStrategiesCopier.copy(serverStrategies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serverStrategies(ServerStrategy ... serverStrategies) {
            this.serverStrategies(Arrays.asList(serverStrategies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serverStrategies(Consumer<ServerStrategy.Builder> ... serverStrategies) {
            this.serverStrategies(Stream.of(serverStrategies).map(c -> (ServerStrategy)((ServerStrategy.Builder)ServerStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetServerStrategiesResponse build() {
            return new GetServerStrategiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServerStrategiesResponse> {
        public Builder serverStrategies(Collection<ServerStrategy> var1);

        public Builder serverStrategies(ServerStrategy ... var1);

        public Builder serverStrategies(Consumer<ServerStrategy.Builder> ... var1);
    }
}

