/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentCriteria;
import software.amazon.awssdk.services.migrationhubstrategy.model.Group;
import software.amazon.awssdk.services.migrationhubstrategy.model.GroupIdsCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationComponentsRequest
extends MigrationHubStrategyRequest
implements ToCopyableBuilder<Builder, ListApplicationComponentsRequest> {
    private static final SdkField<String> APPLICATION_COMPONENT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationComponentCriteria").getter(ListApplicationComponentsRequest.getter(ListApplicationComponentsRequest::applicationComponentCriteriaAsString)).setter(ListApplicationComponentsRequest.setter(Builder::applicationComponentCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationComponentCriteria").build()}).build();
    private static final SdkField<String> FILTER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterValue").getter(ListApplicationComponentsRequest.getter(ListApplicationComponentsRequest::filterValue)).setter(ListApplicationComponentsRequest.setter(Builder::filterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterValue").build()}).build();
    private static final SdkField<List<Group>> GROUP_ID_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupIdFilter").getter(ListApplicationComponentsRequest.getter(ListApplicationComponentsRequest::groupIdFilter)).setter(ListApplicationComponentsRequest.setter(Builder::groupIdFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupIdFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Group::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListApplicationComponentsRequest.getter(ListApplicationComponentsRequest::maxResults)).setter(ListApplicationComponentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListApplicationComponentsRequest.getter(ListApplicationComponentsRequest::nextToken)).setter(ListApplicationComponentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sort").getter(ListApplicationComponentsRequest.getter(ListApplicationComponentsRequest::sortAsString)).setter(ListApplicationComponentsRequest.setter(Builder::sort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_COMPONENT_CRITERIA_FIELD, FILTER_VALUE_FIELD, GROUP_ID_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD));
    private final String applicationComponentCriteria;
    private final String filterValue;
    private final List<Group> groupIdFilter;
    private final Integer maxResults;
    private final String nextToken;
    private final String sort;

    private ListApplicationComponentsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationComponentCriteria = builder.applicationComponentCriteria;
        this.filterValue = builder.filterValue;
        this.groupIdFilter = builder.groupIdFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
    }

    public final ApplicationComponentCriteria applicationComponentCriteria() {
        return ApplicationComponentCriteria.fromValue(this.applicationComponentCriteria);
    }

    public final String applicationComponentCriteriaAsString() {
        return this.applicationComponentCriteria;
    }

    public final String filterValue() {
        return this.filterValue;
    }

    public final boolean hasGroupIdFilter() {
        return this.groupIdFilter != null && !(this.groupIdFilter instanceof SdkAutoConstructList);
    }

    public final List<Group> groupIdFilter() {
        return this.groupIdFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final SortOrder sort() {
        return SortOrder.fromValue(this.sort);
    }

    public final String sortAsString() {
        return this.sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationComponentCriteriaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupIdFilter() ? this.groupIdFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationComponentsRequest)) {
            return false;
        }
        ListApplicationComponentsRequest other = (ListApplicationComponentsRequest)((Object)obj);
        return Objects.equals(this.applicationComponentCriteriaAsString(), other.applicationComponentCriteriaAsString()) && Objects.equals(this.filterValue(), other.filterValue()) && this.hasGroupIdFilter() == other.hasGroupIdFilter() && Objects.equals(this.groupIdFilter(), other.groupIdFilter()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortAsString(), other.sortAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationComponentsRequest").add("ApplicationComponentCriteria", (Object)this.applicationComponentCriteriaAsString()).add("FilterValue", (Object)this.filterValue()).add("GroupIdFilter", this.hasGroupIdFilter() ? this.groupIdFilter() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Sort", (Object)this.sortAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationComponentCriteria": {
                return Optional.ofNullable(clazz.cast(this.applicationComponentCriteriaAsString()));
            }
            case "filterValue": {
                return Optional.ofNullable(clazz.cast(this.filterValue()));
            }
            case "groupIdFilter": {
                return Optional.ofNullable(clazz.cast(this.groupIdFilter()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sortAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationComponentsRequest, T> g) {
        return obj -> g.apply((ListApplicationComponentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyRequest.BuilderImpl
    implements Builder {
        private String applicationComponentCriteria;
        private String filterValue;
        private List<Group> groupIdFilter = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private String sort;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationComponentsRequest model) {
            super(model);
            this.applicationComponentCriteria(model.applicationComponentCriteria);
            this.filterValue(model.filterValue);
            this.groupIdFilter(model.groupIdFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sort(model.sort);
        }

        public final String getApplicationComponentCriteria() {
            return this.applicationComponentCriteria;
        }

        public final void setApplicationComponentCriteria(String applicationComponentCriteria) {
            this.applicationComponentCriteria = applicationComponentCriteria;
        }

        @Override
        @Transient
        public final Builder applicationComponentCriteria(String applicationComponentCriteria) {
            this.applicationComponentCriteria = applicationComponentCriteria;
            return this;
        }

        @Override
        @Transient
        public final Builder applicationComponentCriteria(ApplicationComponentCriteria applicationComponentCriteria) {
            this.applicationComponentCriteria(applicationComponentCriteria == null ? null : applicationComponentCriteria.toString());
            return this;
        }

        public final String getFilterValue() {
            return this.filterValue;
        }

        public final void setFilterValue(String filterValue) {
            this.filterValue = filterValue;
        }

        @Override
        @Transient
        public final Builder filterValue(String filterValue) {
            this.filterValue = filterValue;
            return this;
        }

        public final List<Group.Builder> getGroupIdFilter() {
            List<Group.Builder> result = GroupIdsCopier.copyToBuilder(this.groupIdFilter);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupIdFilter(Collection<Group.BuilderImpl> groupIdFilter) {
            this.groupIdFilter = GroupIdsCopier.copyFromBuilder(groupIdFilter);
        }

        @Override
        @Transient
        public final Builder groupIdFilter(Collection<Group> groupIdFilter) {
            this.groupIdFilter = GroupIdsCopier.copy(groupIdFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groupIdFilter(Group ... groupIdFilter) {
            this.groupIdFilter(Arrays.asList(groupIdFilter));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groupIdFilter(Consumer<Group.Builder> ... groupIdFilter) {
            this.groupIdFilter(Stream.of(groupIdFilter).map(c -> (Group)((Group.Builder)Group.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSort() {
            return this.sort;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        @Override
        @Transient
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        @Transient
        public final Builder sort(SortOrder sort) {
            this.sort(sort == null ? null : sort.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListApplicationComponentsRequest build() {
            return new ListApplicationComponentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationComponentsRequest> {
        public Builder applicationComponentCriteria(String var1);

        public Builder applicationComponentCriteria(ApplicationComponentCriteria var1);

        public Builder filterValue(String var1);

        public Builder groupIdFilter(Collection<Group> var1);

        public Builder groupIdFilter(Group ... var1);

        public Builder groupIdFilter(Consumer<Group.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sort(String var1);

        public Builder sort(SortOrder var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

