/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VersionControl {
    GITHUB("GITHUB"),
    GITHUB_ENTERPRISE("GITHUB_ENTERPRISE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VersionControl> VALUE_MAP;
    private final String value;

    private VersionControl(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VersionControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VersionControl> knownValues() {
        EnumSet<VersionControl> knownValues = EnumSet.allOf(VersionControl.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VersionControl.class, VersionControl::toString);
    }
}

