/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EulaAcceptance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EulaAcceptance> {
    private static final SdkField<Instant> ACCEPTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("acceptedAt").getter(EulaAcceptance.getter(EulaAcceptance::acceptedAt)).setter(EulaAcceptance.setter(Builder::acceptedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ACCEPTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("acceptedBy").getter(EulaAcceptance.getter(EulaAcceptance::acceptedBy)).setter(EulaAcceptance.setter(Builder::acceptedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedBy").build()}).build();
    private static final SdkField<String> ACCEPTEE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accepteeId").getter(EulaAcceptance.getter(EulaAcceptance::accepteeId)).setter(EulaAcceptance.setter(Builder::accepteeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accepteeId").build()}).build();
    private static final SdkField<String> EULA_ACCEPTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eulaAcceptanceId").getter(EulaAcceptance.getter(EulaAcceptance::eulaAcceptanceId)).setter(EulaAcceptance.setter(Builder::eulaAcceptanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulaAcceptanceId").build()}).build();
    private static final SdkField<String> EULA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eulaId").getter(EulaAcceptance.getter(EulaAcceptance::eulaId)).setter(EulaAcceptance.setter(Builder::eulaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulaId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTED_AT_FIELD, ACCEPTED_BY_FIELD, ACCEPTEE_ID_FIELD, EULA_ACCEPTANCE_ID_FIELD, EULA_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant acceptedAt;
    private final String acceptedBy;
    private final String accepteeId;
    private final String eulaAcceptanceId;
    private final String eulaId;

    private EulaAcceptance(BuilderImpl builder) {
        this.acceptedAt = builder.acceptedAt;
        this.acceptedBy = builder.acceptedBy;
        this.accepteeId = builder.accepteeId;
        this.eulaAcceptanceId = builder.eulaAcceptanceId;
        this.eulaId = builder.eulaId;
    }

    public final Instant acceptedAt() {
        return this.acceptedAt;
    }

    public final String acceptedBy() {
        return this.acceptedBy;
    }

    public final String accepteeId() {
        return this.accepteeId;
    }

    public final String eulaAcceptanceId() {
        return this.eulaAcceptanceId;
    }

    public final String eulaId() {
        return this.eulaId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.accepteeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eulaAcceptanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eulaId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EulaAcceptance)) {
            return false;
        }
        EulaAcceptance other = (EulaAcceptance)obj;
        return Objects.equals(this.acceptedAt(), other.acceptedAt()) && Objects.equals(this.acceptedBy(), other.acceptedBy()) && Objects.equals(this.accepteeId(), other.accepteeId()) && Objects.equals(this.eulaAcceptanceId(), other.eulaAcceptanceId()) && Objects.equals(this.eulaId(), other.eulaId());
    }

    public final String toString() {
        return ToString.builder((String)"EulaAcceptance").add("AcceptedAt", (Object)this.acceptedAt()).add("AcceptedBy", (Object)this.acceptedBy()).add("AccepteeId", (Object)this.accepteeId()).add("EulaAcceptanceId", (Object)this.eulaAcceptanceId()).add("EulaId", (Object)this.eulaId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceptedAt": {
                return Optional.ofNullable(clazz.cast(this.acceptedAt()));
            }
            case "acceptedBy": {
                return Optional.ofNullable(clazz.cast(this.acceptedBy()));
            }
            case "accepteeId": {
                return Optional.ofNullable(clazz.cast(this.accepteeId()));
            }
            case "eulaAcceptanceId": {
                return Optional.ofNullable(clazz.cast(this.eulaAcceptanceId()));
            }
            case "eulaId": {
                return Optional.ofNullable(clazz.cast(this.eulaId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EulaAcceptance, T> g) {
        return obj -> g.apply((EulaAcceptance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant acceptedAt;
        private String acceptedBy;
        private String accepteeId;
        private String eulaAcceptanceId;
        private String eulaId;

        private BuilderImpl() {
        }

        private BuilderImpl(EulaAcceptance model) {
            this.acceptedAt(model.acceptedAt);
            this.acceptedBy(model.acceptedBy);
            this.accepteeId(model.accepteeId);
            this.eulaAcceptanceId(model.eulaAcceptanceId);
            this.eulaId(model.eulaId);
        }

        public final Instant getAcceptedAt() {
            return this.acceptedAt;
        }

        public final void setAcceptedAt(Instant acceptedAt) {
            this.acceptedAt = acceptedAt;
        }

        @Override
        @Transient
        public final Builder acceptedAt(Instant acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        public final String getAcceptedBy() {
            return this.acceptedBy;
        }

        public final void setAcceptedBy(String acceptedBy) {
            this.acceptedBy = acceptedBy;
        }

        @Override
        @Transient
        public final Builder acceptedBy(String acceptedBy) {
            this.acceptedBy = acceptedBy;
            return this;
        }

        public final String getAccepteeId() {
            return this.accepteeId;
        }

        public final void setAccepteeId(String accepteeId) {
            this.accepteeId = accepteeId;
        }

        @Override
        @Transient
        public final Builder accepteeId(String accepteeId) {
            this.accepteeId = accepteeId;
            return this;
        }

        public final String getEulaAcceptanceId() {
            return this.eulaAcceptanceId;
        }

        public final void setEulaAcceptanceId(String eulaAcceptanceId) {
            this.eulaAcceptanceId = eulaAcceptanceId;
        }

        @Override
        @Transient
        public final Builder eulaAcceptanceId(String eulaAcceptanceId) {
            this.eulaAcceptanceId = eulaAcceptanceId;
            return this;
        }

        public final String getEulaId() {
            return this.eulaId;
        }

        public final void setEulaId(String eulaId) {
            this.eulaId = eulaId;
        }

        @Override
        @Transient
        public final Builder eulaId(String eulaId) {
            this.eulaId = eulaId;
            return this;
        }

        public EulaAcceptance build() {
            return new EulaAcceptance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EulaAcceptance> {
        public Builder acceptedAt(Instant var1);

        public Builder acceptedBy(String var1);

        public Builder accepteeId(String var1);

        public Builder eulaAcceptanceId(String var1);

        public Builder eulaId(String var1);
    }
}

