/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.LaunchProfile;
import software.amazon.awssdk.services.nimble.model.NimbleResponse;
import software.amazon.awssdk.services.nimble.model.StreamingImage;
import software.amazon.awssdk.services.nimble.model.StreamingImageListCopier;
import software.amazon.awssdk.services.nimble.model.StudioComponentSummary;
import software.amazon.awssdk.services.nimble.model.StudioComponentSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLaunchProfileDetailsResponse
extends NimbleResponse
implements ToCopyableBuilder<Builder, GetLaunchProfileDetailsResponse> {
    private static final SdkField<LaunchProfile> LAUNCH_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchProfile").getter(GetLaunchProfileDetailsResponse.getter(GetLaunchProfileDetailsResponse::launchProfile)).setter(GetLaunchProfileDetailsResponse.setter(Builder::launchProfile)).constructor(LaunchProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfile").build()}).build();
    private static final SdkField<List<StreamingImage>> STREAMING_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("streamingImages").getter(GetLaunchProfileDetailsResponse.getter(GetLaunchProfileDetailsResponse::streamingImages)).setter(GetLaunchProfileDetailsResponse.setter(Builder::streamingImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamingImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StudioComponentSummary>> STUDIO_COMPONENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("studioComponentSummaries").getter(GetLaunchProfileDetailsResponse.getter(GetLaunchProfileDetailsResponse::studioComponentSummaries)).setter(GetLaunchProfileDetailsResponse.setter(Builder::studioComponentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StudioComponentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_PROFILE_FIELD, STREAMING_IMAGES_FIELD, STUDIO_COMPONENT_SUMMARIES_FIELD));
    private final LaunchProfile launchProfile;
    private final List<StreamingImage> streamingImages;
    private final List<StudioComponentSummary> studioComponentSummaries;

    private GetLaunchProfileDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.launchProfile = builder.launchProfile;
        this.streamingImages = builder.streamingImages;
        this.studioComponentSummaries = builder.studioComponentSummaries;
    }

    public final LaunchProfile launchProfile() {
        return this.launchProfile;
    }

    public final boolean hasStreamingImages() {
        return this.streamingImages != null && !(this.streamingImages instanceof SdkAutoConstructList);
    }

    public final List<StreamingImage> streamingImages() {
        return this.streamingImages;
    }

    public final boolean hasStudioComponentSummaries() {
        return this.studioComponentSummaries != null && !(this.studioComponentSummaries instanceof SdkAutoConstructList);
    }

    public final List<StudioComponentSummary> studioComponentSummaries() {
        return this.studioComponentSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.launchProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreamingImages() ? this.streamingImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStudioComponentSummaries() ? this.studioComponentSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLaunchProfileDetailsResponse)) {
            return false;
        }
        GetLaunchProfileDetailsResponse other = (GetLaunchProfileDetailsResponse)((Object)obj);
        return Objects.equals(this.launchProfile(), other.launchProfile()) && this.hasStreamingImages() == other.hasStreamingImages() && Objects.equals(this.streamingImages(), other.streamingImages()) && this.hasStudioComponentSummaries() == other.hasStudioComponentSummaries() && Objects.equals(this.studioComponentSummaries(), other.studioComponentSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"GetLaunchProfileDetailsResponse").add("LaunchProfile", (Object)this.launchProfile()).add("StreamingImages", this.hasStreamingImages() ? this.streamingImages() : null).add("StudioComponentSummaries", this.hasStudioComponentSummaries() ? this.studioComponentSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "launchProfile": {
                return Optional.ofNullable(clazz.cast(this.launchProfile()));
            }
            case "streamingImages": {
                return Optional.ofNullable(clazz.cast(this.streamingImages()));
            }
            case "studioComponentSummaries": {
                return Optional.ofNullable(clazz.cast(this.studioComponentSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLaunchProfileDetailsResponse, T> g) {
        return obj -> g.apply((GetLaunchProfileDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleResponse.BuilderImpl
    implements Builder {
        private LaunchProfile launchProfile;
        private List<StreamingImage> streamingImages = DefaultSdkAutoConstructList.getInstance();
        private List<StudioComponentSummary> studioComponentSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLaunchProfileDetailsResponse model) {
            super(model);
            this.launchProfile(model.launchProfile);
            this.streamingImages(model.streamingImages);
            this.studioComponentSummaries(model.studioComponentSummaries);
        }

        public final LaunchProfile.Builder getLaunchProfile() {
            return this.launchProfile != null ? this.launchProfile.toBuilder() : null;
        }

        public final void setLaunchProfile(LaunchProfile.BuilderImpl launchProfile) {
            this.launchProfile = launchProfile != null ? launchProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder launchProfile(LaunchProfile launchProfile) {
            this.launchProfile = launchProfile;
            return this;
        }

        public final List<StreamingImage.Builder> getStreamingImages() {
            List<StreamingImage.Builder> result = StreamingImageListCopier.copyToBuilder(this.streamingImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamingImages(Collection<StreamingImage.BuilderImpl> streamingImages) {
            this.streamingImages = StreamingImageListCopier.copyFromBuilder(streamingImages);
        }

        @Override
        @Transient
        public final Builder streamingImages(Collection<StreamingImage> streamingImages) {
            this.streamingImages = StreamingImageListCopier.copy(streamingImages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamingImages(StreamingImage ... streamingImages) {
            this.streamingImages(Arrays.asList(streamingImages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamingImages(Consumer<StreamingImage.Builder> ... streamingImages) {
            this.streamingImages(Stream.of(streamingImages).map(c -> (StreamingImage)((StreamingImage.Builder)StreamingImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StudioComponentSummary.Builder> getStudioComponentSummaries() {
            List<StudioComponentSummary.Builder> result = StudioComponentSummaryListCopier.copyToBuilder(this.studioComponentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStudioComponentSummaries(Collection<StudioComponentSummary.BuilderImpl> studioComponentSummaries) {
            this.studioComponentSummaries = StudioComponentSummaryListCopier.copyFromBuilder(studioComponentSummaries);
        }

        @Override
        @Transient
        public final Builder studioComponentSummaries(Collection<StudioComponentSummary> studioComponentSummaries) {
            this.studioComponentSummaries = StudioComponentSummaryListCopier.copy(studioComponentSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studioComponentSummaries(StudioComponentSummary ... studioComponentSummaries) {
            this.studioComponentSummaries(Arrays.asList(studioComponentSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studioComponentSummaries(Consumer<StudioComponentSummary.Builder> ... studioComponentSummaries) {
            this.studioComponentSummaries(Stream.of(studioComponentSummaries).map(c -> (StudioComponentSummary)((StudioComponentSummary.Builder)StudioComponentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetLaunchProfileDetailsResponse build() {
            return new GetLaunchProfileDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLaunchProfileDetailsResponse> {
        public Builder launchProfile(LaunchProfile var1);

        default public Builder launchProfile(Consumer<LaunchProfile.Builder> launchProfile) {
            return this.launchProfile((LaunchProfile)((LaunchProfile.Builder)LaunchProfile.builder().applyMutation(launchProfile)).build());
        }

        public Builder streamingImages(Collection<StreamingImage> var1);

        public Builder streamingImages(StreamingImage ... var1);

        public Builder streamingImages(Consumer<StreamingImage.Builder> ... var1);

        public Builder studioComponentSummaries(Collection<StudioComponentSummary> var1);

        public Builder studioComponentSummaries(StudioComponentSummary ... var1);

        public Builder studioComponentSummaries(Consumer<StudioComponentSummary.Builder> ... var1);
    }
}

