/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.model.StudioComponentState;
import software.amazon.awssdk.services.nimble.model.StudioComponentStateListCopier;
import software.amazon.awssdk.services.nimble.model.StudioComponentType;
import software.amazon.awssdk.services.nimble.model.StudioComponentTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStudioComponentsRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, ListStudioComponentsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListStudioComponentsRequest.getter(ListStudioComponentsRequest::maxResults)).setter(ListStudioComponentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStudioComponentsRequest.getter(ListStudioComponentsRequest::nextToken)).setter(ListStudioComponentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("states").getter(ListStudioComponentsRequest.getter(ListStudioComponentsRequest::statesAsStrings)).setter(ListStudioComponentsRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("states").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(ListStudioComponentsRequest.getter(ListStudioComponentsRequest::studioId)).setter(ListStudioComponentsRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("types").getter(ListStudioComponentsRequest.getter(ListStudioComponentsRequest::typesAsStrings)).setter(ListStudioComponentsRequest.setter(Builder::typesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STATES_FIELD, STUDIO_ID_FIELD, TYPES_FIELD));
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> states;
    private final String studioId;
    private final List<String> types;

    private ListStudioComponentsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.states = builder.states;
        this.studioId = builder.studioId;
        this.types = builder.types;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<StudioComponentState> states() {
        return StudioComponentStateListCopier.copyStringToEnum(this.states);
    }

    public final boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public final List<String> statesAsStrings() {
        return this.states;
    }

    public final String studioId() {
        return this.studioId;
    }

    public final List<StudioComponentType> types() {
        return StudioComponentTypeListCopier.copyStringToEnum(this.types);
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> typesAsStrings() {
        return this.types;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStates() ? this.statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.typesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudioComponentsRequest)) {
            return false;
        }
        ListStudioComponentsRequest other = (ListStudioComponentsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasStates() == other.hasStates() && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && Objects.equals(this.studioId(), other.studioId()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.typesAsStrings(), other.typesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListStudioComponentsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("States", this.hasStates() ? this.statesAsStrings() : null).add("StudioId", (Object)this.studioId()).add("Types", this.hasTypes() ? this.typesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "states": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
            case "types": {
                return Optional.ofNullable(clazz.cast(this.typesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStudioComponentsRequest, T> g) {
        return obj -> g.apply((ListStudioComponentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private String studioId;
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudioComponentsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.statesWithStrings(model.states);
            this.studioId(model.studioId);
            this.typesWithStrings(model.types);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getStates() {
            if (this.states instanceof SdkAutoConstructList) {
                return null;
            }
            return this.states;
        }

        public final void setStates(Collection<String> states) {
            this.states = StudioComponentStateListCopier.copy(states);
        }

        @Override
        @Transient
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = StudioComponentStateListCopier.copy(states);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        @Transient
        public final Builder states(Collection<StudioComponentState> states) {
            this.states = StudioComponentStateListCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder states(StudioComponentState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        @Transient
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = StudioComponentTypeListCopier.copy(types);
        }

        @Override
        @Transient
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = StudioComponentTypeListCopier.copy(types);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder typesWithStrings(String ... types) {
            this.typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        @Transient
        public final Builder types(Collection<StudioComponentType> types) {
            this.types = StudioComponentTypeListCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder types(StudioComponentType ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStudioComponentsRequest build() {
            return new ListStudioComponentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStudioComponentsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<StudioComponentState> var1);

        public Builder states(StudioComponentState ... var1);

        public Builder studioId(String var1);

        public Builder typesWithStrings(Collection<String> var1);

        public Builder typesWithStrings(String ... var1);

        public Builder types(Collection<StudioComponentType> var1);

        public Builder types(StudioComponentType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

